/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.launching;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.SerialFormat;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.impl.ResourceManager_impl;
import org.apache.uima.ruta.engine.Ruta;
import org.apache.uima.ruta.engine.RutaEngine;
import org.apache.uima.util.CasIOUtils;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.impl.ProcessTrace_impl;
import org.xml.sax.SAXException;

public class RutaLauncher {
    public static final List<String> COMMON_PLAIN_TEXT_FILE_EXTENSIONS = Arrays.asList(".txt", ".csv", "html", "xhtml");
    public static final String URL_ENCODING = "UTF-8";
    private static File descriptor;
    private static File inputFolder;
    private static File outputFolder;
    private static boolean inputRecursive;
    private static boolean addSDI;
    private static String inputEncoding;
    private static String launchMode;
    private static String view;
    private static String defaultFormat;
    private static String classPath;

    private static boolean parseCmdLineArgs(String[] args) throws UnsupportedEncodingException {
        int index = 0;
        int count = 0;
        while (index < args.length) {
            String each;
            if ("-inputFolder".equals(each = args[index++])) {
                if (index >= args.length) {
                    return false;
                }
                ++count;
                inputFolder = new File(URLDecoder.decode(args[index++], URL_ENCODING));
                continue;
            }
            if ("-outputFolder".equals(each)) {
                if (index >= args.length) {
                    return false;
                }
                outputFolder = new File(URLDecoder.decode(args[index++], URL_ENCODING));
                continue;
            }
            if ("-descriptor".equals(each)) {
                if (index >= args.length) {
                    return false;
                }
                ++count;
                descriptor = new File(URLDecoder.decode(args[index++], URL_ENCODING));
                continue;
            }
            if ("-inputRecursive".equals(each)) {
                if (index >= args.length) {
                    return false;
                }
                inputRecursive = Boolean.parseBoolean(args[index++]);
                continue;
            }
            if ("org.apache.uima.ruta.ide.launching.addsdi".equals(each)) {
                if (index >= args.length) {
                    return false;
                }
                addSDI = Boolean.parseBoolean(args[index++]);
                continue;
            }
            if ("-inputRecursive".equals(each)) {
                if (index >= args.length) {
                    return false;
                }
                inputEncoding = args[index++];
                continue;
            }
            if ("-mode".equals(each)) {
                if (index >= args.length) {
                    return false;
                }
                launchMode = args[index++];
                continue;
            }
            if ("-view".equals(each)) {
                if (index >= args.length) {
                    return false;
                }
                view = args[index++];
                continue;
            }
            if ("org.apache.uima.ruta.ide.launching.defaultFormat".equals(each)) {
                if (index >= args.length) {
                    return false;
                }
                defaultFormat = args[index++];
                continue;
            }
            if (!"org.apache.uima.ruta.ide.launching.classPath".equals(each)) continue;
            if (index >= args.length) {
                return false;
            }
            classPath = URLDecoder.decode(args[index++], URL_ENCODING);
        }
        return count == 2;
    }

    public static void main(String[] args) throws Exception {
        if (!RutaLauncher.parseCmdLineArgs(args)) {
            throw new IllegalArgumentException("Passed arguments are invalid!");
        }
        ResourceManager_impl resourceManager = null;
        if (classPath != null) {
            String[] split = classPath.split(File.pathSeparator);
            ClassLoader classLoader = RutaLauncher.getClassLoader(Arrays.asList(split));
            resourceManager = new ResourceManager_impl(classLoader);
        }
        AnalysisEngine ae = Ruta.wrapAnalysisEngine((URL)descriptor.toURI().toURL(), (String)view, (boolean)true, (String)inputEncoding, resourceManager);
        RutaLauncher.configure(ae);
        CAS cas = ae.newCAS();
        List<File> inputFiles = RutaLauncher.getFiles(inputFolder, inputRecursive);
        for (File file : inputFiles) {
            RutaLauncher.processFile(file, ae, cas);
        }
        ae.batchProcessComplete((ProcessTrace)new ProcessTrace_impl());
        ae.collectionProcessComplete((ProcessTrace)new ProcessTrace_impl());
        cas.release();
        ae.destroy();
    }

    private static void processFile(File file, AnalysisEngine ae, CAS cas) throws IOException, AnalysisEngineProcessException, SAXException {
        String extension;
        SerialFormat format;
        if (view != null) {
            boolean found = false;
            Iterator viewIterator = cas.getViewIterator();
            while (viewIterator.hasNext()) {
                CAS each = (CAS)viewIterator.next();
                String viewName = each.getViewName();
                if (!viewName.equals(view)) continue;
                cas = cas.getView(view);
                found = true;
                break;
            }
            if (!found) {
                cas = cas.createView(view);
            }
        }
        if ((format = SerialFormat.valueOf((String)defaultFormat)) == SerialFormat.UNKNOWN) {
            format = SerialFormat.XMI;
        }
        if (COMMON_PLAIN_TEXT_FILE_EXTENSIONS.contains(extension = FilenameUtils.getExtension((String)file.getName()))) {
            String document = FileUtils.file2String((File)file, (String)inputEncoding);
            cas.setDocumentText(document);
        } else {
            try {
                format = CasIOUtils.load((URL)file.toURI().toURL(), null, (CAS)cas, (boolean)true);
            }
            catch (Exception e) {
                String document = FileUtils.file2String((File)file, (String)inputEncoding);
                cas.setDocumentText(document);
            }
        }
        if (addSDI) {
            RutaEngine.removeSourceDocumentInformation((CAS)cas);
            RutaEngine.addSourceDocumentInformation((CAS)cas, (File)file);
        }
        ae.process(cas);
        if (outputFolder != null) {
            File outputFile = RutaLauncher.getOutputFile(file, inputFolder, outputFolder, format);
            FileOutputStream os = new FileOutputStream(outputFile);
            CasIOUtils.save((CAS)cas, (OutputStream)os, (SerialFormat)format);
            IOUtils.closeQuietly((OutputStream)os);
        }
        cas.reset();
    }

    private static void configure(AnalysisEngine ae) throws ResourceConfigurationException {
        if ("debug".equals(launchMode)) {
            ae.setConfigParameterValue("debug", (Object)true);
            ae.setConfigParameterValue("debugWithMatches", (Object)true);
            ae.setConfigParameterValue("profile", (Object)true);
            ae.setConfigParameterValue("statistics", (Object)true);
            ae.setConfigParameterValue("createdBy", (Object)true);
        }
        ae.reconfigure();
    }

    private static List<File> getFiles(File dir, boolean recusive) {
        ArrayList<File> result = new ArrayList<File>();
        File[] listFiles = dir.listFiles();
        if (listFiles != null) {
            for (File each : listFiles) {
                if (each.isHidden()) continue;
                if (each.isFile()) {
                    result.add(each);
                    continue;
                }
                if (!each.isDirectory() || !recusive) continue;
                result.addAll(RutaLauncher.getFiles(each, recusive));
            }
        }
        return result;
    }

    private static File getOutputFile(File inputFile, File inputFolder, File outputFolder, SerialFormat format) {
        String ext;
        URI relativize = inputFolder.toURI().relativize(inputFile.toURI());
        String path = relativize.getPath();
        if (!path.endsWith(ext = "." + format.getDefaultFileExtension())) {
            path = path + ext;
        }
        File result = new File(outputFolder, path);
        result.getParentFile().mkdirs();
        return result;
    }

    private static ClassLoader getClassLoader(Collection<String> classPath) throws MalformedURLException {
        URL[] urls = new URL[classPath.size()];
        int counter = 0;
        for (String dep : classPath) {
            urls[counter] = new File(dep).toURI().toURL();
            ++counter;
        }
        URLClassLoader classLoader = new URLClassLoader(urls);
        return classLoader;
    }

    static {
        outputFolder = null;
        inputRecursive = false;
        addSDI = false;
        inputEncoding = URL_ENCODING;
        launchMode = "run";
        view = null;
        defaultFormat = null;
        classPath = null;
    }
}

