/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.text;

import java.util.ArrayList;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.env.ModuleSource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;

public final class RutaPairMatcher
implements ICharacterPairMatcher {
    private IDocument fDocument;
    private int fOffset;
    private int fStartPos;
    private int fEndPos;
    private int fAnchor;
    private ScriptEditor editor;
    private PairBlock[] cachedPairs;
    private long cachedStamp = -1L;
    private long cachedHash = -1L;

    public RutaPairMatcher(char[] pairs, ScriptEditor editor) {
        this.editor = editor;
    }

    private PairBlock[] computePairRanges(final int offset, String contents) {
        ArrayList result;
        block5: {
            ISourceParser pp = null;
            pp = DLTKLanguageManager.getSourceParser((String)"org.apache.uima.ruta.ide.nature");
            ModuleDeclaration md = null;
            IModelElement el = this.editor.getInputModelElement();
            if (el != null && el instanceof ISourceModule) {
                md = SourceParserUtil.getModuleDeclaration((ISourceModule)((ISourceModule)el), null);
            }
            if (md == null) {
                md = (ModuleDeclaration)pp.parse((IModuleSource)new ModuleSource(contents), null);
            }
            if (md == null) {
                return new PairBlock[0];
            }
            result = new ArrayList();
            try {
                md.traverse(new ASTVisitor(){

                    public boolean visitGeneral(ASTNode node) throws Exception {
                        if (node instanceof StringLiteral) {
                            StringLiteral be = (StringLiteral)node;
                            result.add(new PairBlock(offset + be.sourceStart(), offset + be.sourceEnd() - 1, '\"'));
                        } else if (node instanceof Block) {
                            Block be = (Block)node;
                            result.add(new PairBlock(offset + be.sourceStart(), offset + be.sourceEnd() - 1, '{'));
                        }
                        return super.visitGeneral(node);
                    }
                });
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block5;
                e.printStackTrace();
            }
        }
        return result.toArray(new PairBlock[result.size()]);
    }

    private void recalc() throws BadLocationException {
        String content = this.fDocument.get(0, this.fDocument.getLength());
        this.cachedPairs = this.computePairRanges(0, content);
        if (this.fDocument instanceof IDocumentExtension4) {
            this.cachedStamp = ((IDocumentExtension4)this.fDocument).getModificationStamp();
        } else {
            this.cachedHash = content.hashCode();
        }
    }

    private void updatePairs() throws BadLocationException {
        String content;
        IDocumentExtension4 document;
        if (this.fDocument instanceof IDocumentExtension4 ? (document = (IDocumentExtension4)this.fDocument).getModificationStamp() == this.cachedStamp : (long)(content = this.fDocument.get(0, this.fDocument.getLength())).hashCode() == this.cachedHash) {
            return;
        }
        this.recalc();
    }

    private static boolean isBrace(char c) {
        return c == '{' || c == '}' || c == '\"' || c == '[' || c == ']';
    }

    public IRegion match(IDocument document, int offset) {
        block5: {
            if (document == null || offset < 0) {
                throw new IllegalArgumentException();
            }
            try {
                this.fOffset = offset;
                this.fDocument = document;
                if (!(RutaPairMatcher.isBrace(this.fDocument.getChar(offset)) || offset != 0 && RutaPairMatcher.isBrace(this.fDocument.getChar(offset - 1)))) {
                    return null;
                }
                this.updatePairs();
                if (this.matchPairsAt() && this.fStartPos != this.fEndPos) {
                    return new Region(this.fStartPos, this.fEndPos - this.fStartPos + 1);
                }
            }
            catch (BadLocationException e) {
                if (!DLTKCore.DEBUG_PARSER) break block5;
                e.printStackTrace();
            }
        }
        return null;
    }

    public int getAnchor() {
        return this.fAnchor;
    }

    public void dispose() {
        this.clear();
        this.fDocument = null;
    }

    public void clear() {
    }

    private boolean matchPairsAt() {
        this.fStartPos = -1;
        this.fEndPos = -1;
        for (int i = 0; i < this.cachedPairs.length; ++i) {
            PairBlock block = this.cachedPairs[i];
            if (this.fOffset == block.end + 1) {
                this.fStartPos = block.start - 1;
                this.fEndPos = block.start;
                this.fAnchor = 1;
                return true;
            }
            if (this.fOffset != block.start + 1) continue;
            this.fStartPos = block.end - 1;
            this.fEndPos = block.end;
            this.fAnchor = 1;
            return true;
        }
        return false;
    }

    private class PairBlock {
        int start;
        int end;
        char c;

        public PairBlock(int start, int end, char c) {
            this.start = start;
            this.end = end;
            this.c = c;
        }
    }
}

