/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.validator;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.ide.parser.ast.RutaRessourceReference;
import org.apache.uima.ruta.ide.validator.RutaCheckerDefaultProblem;
import org.apache.uima.ruta.ide.validator.RutaCheckerProblemFactory;
import org.apache.uima.ruta.ide.validator.RutaCheckerUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension;
import org.eclipse.dltk.core.builder.ISourceLineTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RutaRessourceChecker
implements IBuildParticipant,
IBuildParticipantExtension {
    private IScriptProject project;

    public RutaRessourceChecker(IScriptProject project) throws CoreException {
        this.project = project;
    }

    public boolean beginBuild(int buildType) {
        return true;
    }

    public void endBuild(IProgressMonitor monitor) {
    }

    public void build(IBuildContext context) throws CoreException {
        Object mdObj = context.get(IBuildContext.ATTR_MODULE_DECLARATION);
        if (!(mdObj instanceof ModuleDeclaration)) {
            return;
        }
        ModuleDeclaration md = (ModuleDeclaration)mdObj;
        IProblemReporter problemReporter = context.getProblemReporter();
        ISourceModule smod = context.getSourceModule();
        Set<String> types = null;
        try {
            types = this.importBasicTypeSystem();
        }
        catch (InvalidXMLException e1) {
            System.err.println("ERROR: Failed to get BasicTypeSystem!! " + this.toString());
        }
        catch (IOException e1) {
            System.err.println("ERROR: Failed to get BasicTypeSystem!! " + this.toString());
        }
        if (types == null) {
            types = new HashSet<String>();
        }
        ISourceLineTracker linetracker = context.getLineTracker();
        String fileName = smod.getElementName();
        try {
            TypeCheckerVisitor visitor = new TypeCheckerVisitor(problemReporter, linetracker, fileName, types);
            md.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Set<String> importBasicTypeSystem() throws InvalidXMLException, IOException {
        String basicXmlFile = "BasicTypeSystem";
        Set<String> types = this.importTypeSystem("BasicTypeSystem");
        types.add("Annotation");
        types.add("DocumentAnnotation");
        return types;
    }

    private Set<String> importTypeSystem(String xmlFilePath) throws InvalidXMLException, IOException {
        IFolder folder = this.project.getProject().getFolder(RutaProjectUtils.getDefaultDescriptorLocation());
        String fileExtended = xmlFilePath + ".xml";
        return this.getTypes(folder, fileExtended);
    }

    private Set<String> getTypes(IFolder folder, String filePath) throws InvalidXMLException, IOException {
        Set<String> types = new HashSet<String>();
        IFile iFile = this.getFile(folder, filePath);
        try {
            URL url = iFile.getLocationURI().toURL();
            types = this.getTypes(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return types;
    }

    private IFile getFile(IFolder folder, String filePath) {
        int lastDot = filePath.lastIndexOf(46);
        int sndLastDot = filePath.lastIndexOf(46, lastDot - 1);
        String fName = filePath;
        if (sndLastDot >= 0) {
            String subFolder = filePath.substring(0, sndLastDot);
            folder = folder.getFolder(subFolder);
            fName = filePath.substring(sndLastDot + 1);
        }
        return folder.getFile(fName);
    }

    private Set<String> getTypes(URL resource) throws IOException, InvalidXMLException {
        HashSet<String> types = new HashSet<String>();
        TypeSystemDescription typeSysDescr = null;
        typeSysDescr = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(resource));
        for (TypeDescription each : typeSysDescr.getTypes()) {
            String name = each.getName();
            String[] nameSpace = name.split("[.]");
            types.add(nameSpace[nameSpace.length - 1]);
            StringBuffer fullName = new StringBuffer();
            if (nameSpace.length > 0) {
                fullName.append(nameSpace[0]);
            }
            for (int i = 1; i < nameSpace.length; ++i) {
                if (nameSpace[i].equals("type")) continue;
                fullName.append('.');
                fullName.append(nameSpace[i]);
            }
            types.add(fullName.toString());
        }
        return types;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeCheckerVisitor
    extends ASTVisitor {
        private IProblemReporter rep;
        private String currentFile;
        private ISourceLineTracker linetracker;
        private Set<String> types;
        private RutaCheckerProblemFactory problemFactory;
        private String packageName;
        private static final String errMsgHead = "Cannot find resource \"";
        private static final String errMsgTailDefault = " \" in resource location.";

        public TypeCheckerVisitor(IProblemReporter rep, ISourceLineTracker linetracker, String curFile, Set<String> types) {
            this.problemFactory = new RutaCheckerProblemFactory(curFile, linetracker);
            this.linetracker = linetracker;
            this.rep = rep;
            this.packageName = "";
            this.currentFile = curFile;
            this.types = types;
        }

        public boolean visit(Expression s) throws Exception {
            if (!(s instanceof RutaRessourceReference)) {
                return true;
            }
            RutaRessourceReference resRef = (RutaRessourceReference)s;
            if (RutaCheckerUtils.checkRessourceExistence(resRef.getValue(), RutaRessourceChecker.this.project)) {
                return false;
            }
            String errMsg = errMsgHead + resRef.getValue() + errMsgTailDefault;
            RutaCheckerDefaultProblem problem = new RutaCheckerDefaultProblem(this.currentFile, errMsg, (ASTNode)resRef, this.linetracker.getLineNumberOfOffset(resRef.sourceStart()));
            this.rep.reportProblem((IProblem)problem);
            return false;
        }
    }
}

