/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.constraint;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.cas.FSTypeConstraint;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.jcas.tcas.Annotation;

public class MarkupConstraint
implements FSTypeConstraint {
    private static final long serialVersionUID = 1115953538613617791L;
    private static final Pattern tagPattern = Pattern.compile("<(/)?([A-Za-z\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd_0-9:!=\\-]+)([^>]*)>");
    private final FSTypeConstraint constraint;
    private List<String> tags = new ArrayList<String>();

    public MarkupConstraint(FSTypeConstraint constraint) {
        this.constraint = constraint;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public void removeTag(String tag) {
        this.tags.add(tag);
    }

    public boolean match(FeatureStructure fs) {
        Annotation annotation;
        String text;
        Matcher m;
        boolean result = this.constraint.match(fs);
        if (fs instanceof Annotation && (m = tagPattern.matcher(text = (annotation = (Annotation)fs).getCoveredText())).find()) {
            String lowerCase = m.group(2).toLowerCase();
            result &= this.tags.contains(lowerCase);
        }
        return result;
    }

    public void add(Type type) {
        this.constraint.add(type);
    }

    public void add(String type) {
        this.constraint.add(type);
    }

    public String toString() {
        return this.constraint.toString() + "with " + this.tags;
    }
}

