/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TerminalRutaCondition;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.type.RutaAnnotation;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class ScoreCondition
extends TerminalRutaCondition {
    private final NumberExpression min;
    private final NumberExpression max;
    private final String var;

    public ScoreCondition(NumberExpression min, NumberExpression max, String var) {
        this.min = min == null ? new SimpleNumberExpression(Integer.MIN_VALUE) : min;
        this.max = max == null ? new SimpleNumberExpression(Integer.MAX_VALUE) : max;
        this.var = var;
    }

    public EvaluatedCondition eval(AnnotationFS annotation, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        Type heuristicType = stream.getJCas().getCasType(RutaAnnotation.type);
        List<AnnotationFS> annotationsInWindow = stream.getAnnotationsInWindow(annotation, heuristicType);
        double score = 0.0;
        if (!annotationsInWindow.isEmpty()) {
            RutaAnnotation heuristicAnnotation = (RutaAnnotation)stream.getCas().createAnnotation(heuristicType, annotation.getBegin(), annotation.getEnd());
            heuristicAnnotation.setAnnotation((Annotation)annotation);
            RutaAnnotation tma = stream.getCorrectTMA(annotationsInWindow, heuristicAnnotation);
            score = tma.getScore();
        }
        if (this.var != null) {
            element.getParent().getEnvironment().setVariableValue(this.var, score);
        }
        boolean value = score >= this.min.getDoubleValue(element.getParent()) && score <= this.max.getDoubleValue(element.getParent());
        return new EvaluatedCondition(this, value);
    }

    public NumberExpression getMin() {
        return this.min;
    }

    public NumberExpression getMax() {
        return this.max;
    }

    public String getVar() {
        return this.var;
    }
}

