/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.TypeSensitiveAction;
import org.apache.uima.ruta.expression.list.TypeListExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementMatch;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmarkAllAction
extends TypeSensitiveAction {
    private final TypeListExpression list;

    public UnmarkAllAction(TypeExpression type, TypeListExpression list) {
        super(type);
        this.list = list;
    }

    @Override
    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        ArrayList<Type> retainList = new ArrayList();
        if (this.list != null) {
            retainList = this.list.getList(element.getParent());
        }
        Type t = this.type.getType(element.getParent());
        TypeSystem typeSystem = stream.getCas().getTypeSystem();
        LinkedList<AnnotationFS> toRemove = new LinkedList<AnnotationFS>();
        List<List<RuleElementMatch>> matchInfo = match.getMatchInfo(element);
        for (List<RuleElementMatch> l : matchInfo) {
            RuleElementMatch ruleElementMatch = l.get(0);
            List<AnnotationFS> textsMatched = ruleElementMatch.getTextsMatched();
            for (AnnotationFS each : textsMatched) {
                RutaBasic beginAnchor = stream.getBeginAnchor(each.getBegin());
                Set<AnnotationFS> beginAnchors = beginAnchor.getBeginAnchors(t);
                for (AnnotationFS annotationFS : beginAnchors) {
                    if (annotationFS.getEnd() != each.getEnd() || this.retainType(annotationFS.getType(), retainList, typeSystem)) continue;
                    toRemove.add(annotationFS);
                }
            }
        }
        for (AnnotationFS annotationFS : toRemove) {
            stream.removeAnnotation(annotationFS);
        }
    }

    private boolean retainType(Type type, List<Type> retainList, TypeSystem typeSystem) {
        for (Type each : retainList) {
            if (!typeSystem.subsumes(each, type)) continue;
            return true;
        }
        return false;
    }

    public TypeListExpression getList() {
        return this.list;
    }
}

