/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.Collection;
import java.util.List;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractMarkAction;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.bool.SimpleBooleanExpression;
import org.apache.uima.ruta.expression.list.StringListExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.expression.resource.WordListExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.resource.RutaWordList;
import org.apache.uima.ruta.resource.TreeWordList;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class MarkFastAction
extends AbstractMarkAction {
    private WordListExpression list;
    private StringListExpression stringList;
    private BooleanExpression ignore;
    private NumberExpression ignoreLength;
    private BooleanExpression ignoreWS;

    public MarkFastAction(TypeExpression type, WordListExpression list, BooleanExpression ignore, NumberExpression ignoreLength, BooleanExpression ignoreWS) {
        super(type);
        this.list = list;
        this.ignore = ignore == null ? new SimpleBooleanExpression(false) : ignore;
        this.ignoreLength = ignoreLength == null ? new SimpleNumberExpression(0) : ignoreLength;
        this.ignoreWS = ignoreWS == null ? new SimpleBooleanExpression(true) : ignoreWS;
    }

    public MarkFastAction(TypeExpression type, StringListExpression list, BooleanExpression ignore, NumberExpression ignoreLength, BooleanExpression ignoreWS) {
        super(type);
        this.stringList = list;
        this.ignore = ignore == null ? new SimpleBooleanExpression(false) : ignore;
        this.ignoreLength = ignoreLength == null ? new SimpleNumberExpression(0) : ignoreLength;
        this.ignoreWS = ignoreWS == null ? new SimpleBooleanExpression(true) : ignoreWS;
    }

    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        List<AnnotationFS> matchedAnnotationsOf = match.getMatchedAnnotationsOf(element, stream);
        for (AnnotationFS annotationFS : matchedAnnotationsOf) {
            RutaStream windowStream = stream.getWindowStream(annotationFS, annotationFS.getType());
            RutaWordList wl = null;
            if (this.list != null) {
                wl = this.list.getList(element.getParent());
            } else if (this.stringList != null) {
                wl = new TreeWordList(this.stringList.getList(element.getParent()));
            }
            if (!(wl instanceof TreeWordList)) continue;
            Collection<AnnotationFS> found = wl.find(windowStream, this.ignore.getBooleanValue(element.getParent()), this.ignoreLength.getIntegerValue(element.getParent()), null, 0, this.ignoreWS.getBooleanValue(element.getParent()));
            for (AnnotationFS annotation : found) {
                this.createAnnotation(annotation, element, windowStream, match);
            }
        }
    }

    public WordListExpression getList() {
        return this.list;
    }

    public StringListExpression getStringList() {
        return this.stringList;
    }

    public BooleanExpression getIgnore() {
        return this.ignore;
    }

    public NumberExpression getIgnoreLength() {
        return this.ignoreLength;
    }

    public BooleanExpression getIgnoreWS() {
        return this.ignoreWS;
    }
}

