/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractStructureAction;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateAction
extends AbstractStructureAction {
    private TypeExpression structureType;
    private Map<StringExpression, RutaExpression> features;
    private List<NumberExpression> indexes;

    public CreateAction(TypeExpression structureType, Map<StringExpression, RutaExpression> features, List<NumberExpression> indexes) {
        this.structureType = structureType;
        this.features = features == null ? new HashMap() : features;
        this.indexes = indexes == null || indexes.isEmpty() ? null : indexes;
    }

    @Override
    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        List<Integer> indexList = this.getIndexList(match, element);
        List<AnnotationFS> matchedAnnotations = match.getMatchedAnnotations(stream, indexList, element.getContainer());
        for (AnnotationFS matchedAnnotation : matchedAnnotations) {
            if (matchedAnnotation == null) {
                return;
            }
            Type type = this.structureType.getType(element.getParent());
            FeatureStructure newFS = stream.getCas().createFS(type);
            if (newFS instanceof Annotation) {
                Annotation a = (Annotation)newFS;
                a.setBegin(matchedAnnotation.getBegin());
                a.setEnd(matchedAnnotation.getEnd());
                stream.addAnnotation((AnnotationFS)a, match);
            }
            TOP newStructure = null;
            if (!(newFS instanceof TOP)) continue;
            newStructure = (TOP)newFS;
            this.fillFeatures(newStructure, this.features, matchedAnnotation, element, stream);
            newStructure.addToIndexes();
        }
    }

    protected List<Integer> getIndexList(RuleMatch match, RuleElement element) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        if (this.indexes == null || this.indexes.isEmpty()) {
            int self = element.getContainer().getRuleElements().indexOf(element) + 1;
            indexList.add(self);
            return indexList;
        }
        int last = 0x7FFFFFFE;
        for (NumberExpression each : this.indexes) {
            int value = each.getIntegerValue(element.getParent());
            for (int i = Math.min(value, last + 1); i < value; ++i) {
                indexList.add(i);
            }
            indexList.add(value);
        }
        return indexList;
    }

    public TypeExpression getStructureType() {
        return this.structureType;
    }

    public Map<StringExpression, RutaExpression> getFeatures() {
        return this.features;
    }

    public List<NumberExpression> getIndexes() {
        return this.indexes;
    }
}

