/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.caseditor.view.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.uima.ruta.caseditor.view.tree.ITreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeNode
implements ITreeNode {
    private ITreeNode parent;
    private ArrayList<ITreeNode> children;

    public AbstractTreeNode() {
        this(null);
    }

    public AbstractTreeNode(ITreeNode parent) {
        this.parent = parent;
        this.children = new ArrayList();
    }

    @Override
    public void addChild(ITreeNode child) {
        this.children.add(child);
    }

    @Override
    public ITreeNode[] getChildren() {
        return this.children.toArray(new ITreeNode[0]);
    }

    @Override
    public Iterator<ITreeNode> getChildrenIterator() {
        return this.children.iterator();
    }

    @Override
    public ITreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    @Override
    public void getNodes(LinkedList<ITreeNode> list) {
        Iterator<ITreeNode> iter = this.getChildrenIterator();
        while (iter.hasNext()) {
            ITreeNode node = iter.next();
            list.add(node);
            node.getNodes(list);
        }
    }

    @Override
    public void sort(Comparator<ITreeNode> cp) {
        Collections.sort(this.children, cp);
    }
}

