/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.testing.ui.views;

import org.apache.uima.ruta.testing.ui.views.TestCasData;
import org.apache.uima.ruta.testing.ui.views.TestViewPage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class ListLabelProvider
implements ILabelProvider {
    private final Image blue = TestViewPage.createImage("/icons/bullet_blue.png");
    private final Image green = TestViewPage.createImage("/icons/bullet_green.png");
    private final Image yellow = TestViewPage.createImage("/icons/bullet_yellow.png");
    private final Image orange = TestViewPage.createImage("/icons/bullet_orange.png");
    private final Image red = TestViewPage.createImage("/icons/bullet_red.png");
    private final Image black = TestViewPage.createImage("/icons/bullet_black.png");
    private final Image pink = TestViewPage.createImage("/icons/bullet_pink.png");

    public Image getImage(Object element) {
        if (element instanceof TestCasData) {
            TestCasData testData = (TestCasData)element;
            if (testData.getResultPath() == null) {
                return this.black;
            }
            int tp = testData.getTruePositiveCount();
            int fp = testData.getFalsePositiveCount();
            int fn = testData.getFalseNegativeCount();
            int error = fp + fn;
            double percent = (double)error / (double)tp;
            if (fp == 0 && fn == 0) {
                return this.green;
            }
            if (percent >= 0.25) {
                return this.red;
            }
            if (percent <= 0.05) {
                return this.yellow;
            }
            if (percent < 0.25) {
                return this.orange;
            }
            if (fp == 0) {
                return this.blue;
            }
            if (fn == 0) {
                return this.pink;
            }
        }
        return this.black;
    }

    public String getText(Object element) {
        if (element instanceof TestCasData) {
            TestCasData testData = (TestCasData)element;
            Object lastSegment = testData.getPath().lastSegment();
            if (testData.getResultPath() == null) {
                lastSegment = (String)lastSegment + " [not available]";
            } else {
                int tp = testData.getTruePositiveCount();
                int fp = testData.getFalsePositiveCount();
                int fn = testData.getFalseNegativeCount();
                lastSegment = (String)lastSegment + " [" + tp + "|" + fp + "|" + fn + "]";
            }
            return lastSegment;
        }
        return "error";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.black.dispose();
        this.blue.dispose();
        this.pink.dispose();
        this.green.dispose();
        this.yellow.dispose();
        this.orange.dispose();
        this.red.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

