/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.textruler.TextRulerPlugin;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.extension.TextRulerController;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerController;
import org.apache.uima.ruta.textruler.ui.AddRemoveList;
import org.apache.uima.ruta.textruler.ui.LearnerConfigurator;
import org.apache.uima.ruta.textruler.ui.TextRulerView;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLizable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;

public class TextRulerViewComposite
extends Composite {
    private CheckboxTableViewer algListViewer;
    private AddRemoveList slotTypes;
    private AddRemoveList filterTypes;
    private Button skipPreButton;
    private Button dirButton;
    private ArrayList<LearnerConfigurator> configurators;
    private Label globalStatusLabel;
    private Label label2;
    private Label label1;
    private Text inputDirectoryText;
    private Label methodsLabel;
    private Label filtersLabel;
    private TextRulerView textRulerView;
    private Button fileChooseButton;
    private static Text preFileText;
    private Label label3;
    private HashMap<String, Image> images;
    private Text additionalDirectoryText;
    private Button additionalButton;
    private Label label4;
    private Label label5;
    private Text testDirectoryText;
    private Button testButton;
    private Button showTestsButton;

    public TextRulerViewComposite(Composite parent, int style, TextRulerView textRulerView) {
        super(parent, style);
        this.textRulerView = textRulerView;
        this.initImages();
        this.initGUI();
        ScrolledComposite sComp = new ScrolledComposite(parent, 2816);
        this.setParent((Composite)sComp);
        sComp.setMinSize(this.getSize());
        sComp.setContent((Control)this);
        sComp.setExpandHorizontal(true);
        sComp.setExpandVertical(true);
    }

    private void initGUI() {
        try {
            this.setLayout((Layout)new FormLayout());
            this.setSize(600, 380);
            this.configurators = new ArrayList();
            this.label1 = new Label((Composite)this, 0);
            FormData label1LData = new FormData();
            label1LData.left = new FormAttachment(0, 1000, 12);
            label1LData.top = new FormAttachment(0, 1000, 20);
            label1LData.width = 109;
            this.label1.setLayoutData((Object)label1LData);
            this.label1.setText("Training Data:");
            this.inputDirectoryText = new Text((Composite)this, 2052);
            FormData inputDirectoryTexLData = new FormData();
            inputDirectoryTexLData.width = 300;
            inputDirectoryTexLData.left = new FormAttachment(0, 1000, 126);
            inputDirectoryTexLData.top = new FormAttachment(0, 1000, 20);
            inputDirectoryTexLData.right = new FormAttachment(1000, 1000, -110);
            this.inputDirectoryText.setLayoutData((Object)inputDirectoryTexLData);
            this.inputDirectoryText.setText("");
            this.inputDirectoryText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Text t = (Text)e.widget;
                    t.getText();
                }
            });
            this.dirButton = new Button((Composite)this, 0x1000008);
            FormData dirButtoLData = new FormData();
            dirButtoLData.width = 25;
            dirButtoLData.height = 25;
            dirButtoLData.top = new FormAttachment(0, 1000, 18);
            dirButtoLData.right = new FormAttachment(1000, 1000, -80);
            this.dirButton.setLayoutData((Object)dirButtoLData);
            Image folderIcon = this.getImage("folder");
            this.dirButton.setImage(folderIcon);
            this.dirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DirectoryDialog dlg = new DirectoryDialog(TextRulerViewComposite.this.getShell());
                    dlg.setFilterPath(TextRulerViewComposite.this.inputDirectoryText.getText());
                    dlg.setText("Input Directory");
                    dlg.setMessage("Select a directory with input XMI files for the learning algorithms.");
                    String dir = dlg.open();
                    if (dir != null) {
                        TextRulerViewComposite.this.inputDirectoryText.setText(dir);
                    }
                }
            });
            this.label4 = new Label((Composite)this, 0);
            FormData label4LData = new FormData();
            label4LData.left = new FormAttachment(0, 1000, 12);
            label4LData.top = new FormAttachment(0, 1000, 44);
            label4LData.width = 109;
            this.label4.setLayoutData((Object)label4LData);
            this.label4.setText("Additional Data:");
            this.additionalDirectoryText = new Text((Composite)this, 2052);
            FormData additionalDirectoryTexLData = new FormData();
            additionalDirectoryTexLData.width = 300;
            additionalDirectoryTexLData.left = new FormAttachment(0, 1000, 126);
            additionalDirectoryTexLData.top = new FormAttachment(0, 1000, 44);
            additionalDirectoryTexLData.right = new FormAttachment(1000, 1000, -110);
            this.additionalDirectoryText.setLayoutData((Object)additionalDirectoryTexLData);
            this.additionalDirectoryText.setText("");
            this.additionalDirectoryText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Text t = (Text)e.widget;
                    t.getText();
                }
            });
            this.additionalButton = new Button((Composite)this, 0x1000008);
            FormData additionalButtoLData = new FormData();
            additionalButtoLData.width = 25;
            additionalButtoLData.height = 25;
            additionalButtoLData.top = new FormAttachment(0, 1000, 42);
            additionalButtoLData.right = new FormAttachment(1000, 1000, -80);
            this.additionalButton.setLayoutData((Object)additionalButtoLData);
            folderIcon = this.getImage("folder");
            this.additionalButton.setImage(folderIcon);
            this.additionalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DirectoryDialog dlg = new DirectoryDialog(TextRulerViewComposite.this.getShell());
                    dlg.setFilterPath(TextRulerViewComposite.this.inputDirectoryText.getText());
                    dlg.setText("Additional Directory");
                    dlg.setMessage("Select a directory with input additional XMI files for the learning algorithms.");
                    String dir = dlg.open();
                    if (dir != null) {
                        TextRulerViewComposite.this.additionalDirectoryText.setText(dir);
                    }
                }
            });
            this.label5 = new Label((Composite)this, 0);
            FormData label5LData = new FormData();
            label5LData.left = new FormAttachment(0, 1000, 12);
            label5LData.top = new FormAttachment(0, 1000, 68);
            label5LData.width = 109;
            this.label5.setLayoutData((Object)label5LData);
            this.label5.setText("Test Data:");
            this.testDirectoryText = new Text((Composite)this, 2052);
            FormData testDirectoryTexLData = new FormData();
            testDirectoryTexLData.width = 300;
            testDirectoryTexLData.left = new FormAttachment(0, 1000, 126);
            testDirectoryTexLData.top = new FormAttachment(0, 1000, 68);
            testDirectoryTexLData.right = new FormAttachment(1000, 1000, -110);
            this.testDirectoryText.setLayoutData((Object)testDirectoryTexLData);
            this.testDirectoryText.setText("");
            this.testDirectoryText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Text t = (Text)e.widget;
                    t.getText();
                }
            });
            this.testDirectoryText.setEnabled(false);
            this.testButton = new Button((Composite)this, 0x1000008);
            FormData testButtoLData = new FormData();
            testButtoLData.width = 25;
            testButtoLData.height = 25;
            testButtoLData.top = new FormAttachment(0, 1000, 66);
            testButtoLData.right = new FormAttachment(1000, 1000, -80);
            this.testButton.setLayoutData((Object)testButtoLData);
            folderIcon = this.getImage("folder");
            this.testButton.setImage(folderIcon);
            this.testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DirectoryDialog dlg = new DirectoryDialog(TextRulerViewComposite.this.getShell());
                    dlg.setFilterPath(TextRulerViewComposite.this.inputDirectoryText.getText());
                    dlg.setText("Test Directory");
                    dlg.setMessage("Select a directory with input test XMI files.");
                    String dir = dlg.open();
                    if (dir != null) {
                        TextRulerViewComposite.this.testDirectoryText.setText(dir);
                    }
                }
            });
            this.testButton.setEnabled(false);
            this.showTestsButton = new Button((Composite)this, 16416);
            FormData showTestsButtoLData = new FormData();
            showTestsButtoLData.width = 50;
            showTestsButtoLData.height = 18;
            showTestsButtoLData.top = new FormAttachment(0, 1000, 66);
            showTestsButtoLData.right = new FormAttachment(1000, 1000, -25);
            this.showTestsButton.setLayoutData((Object)showTestsButtoLData);
            this.showTestsButton.setText("eval");
            this.showTestsButton.setEnabled(false);
            this.label3 = new Label((Composite)this, 0);
            FormData label3LData = new FormData();
            label3LData.width = 103;
            label3LData.left = new FormAttachment(0, 1000, 12);
            label3LData.top = new FormAttachment(0, 1000, 92);
            this.label3.setLayoutData((Object)label3LData);
            this.label3.setText("Preprocess Script:");
            preFileText = new Text((Composite)this, 2052);
            FormData preFileTexLData = new FormData();
            preFileTexLData.width = 495;
            preFileTexLData.left = new FormAttachment(0, 1000, 126);
            preFileTexLData.top = new FormAttachment(0, 1000, 92);
            preFileTexLData.right = new FormAttachment(1000, 1000, -110);
            preFileText.setLayoutData((Object)preFileTexLData);
            preFileText.setText("");
            preFileText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Text t = (Text)e.widget;
                    t.getText();
                }
            });
            this.fileChooseButton = new Button((Composite)this, 0x1000008);
            FormData fileChooseButtoLData = new FormData();
            fileChooseButtoLData.width = 25;
            fileChooseButtoLData.height = 25;
            fileChooseButtoLData.top = new FormAttachment(0, 1000, 90);
            fileChooseButtoLData.right = new FormAttachment(1000, 1000, -80);
            this.fileChooseButton.setLayoutData((Object)fileChooseButtoLData);
            Image icon = this.getImage("prepFolder");
            this.fileChooseButton.setImage(icon);
            this.fileChooseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FileDialog fd = new FileDialog(TextRulerViewComposite.this.getShell(), 4096);
                    fd.setText("Choose Ruta Source File");
                    String[] filterExt = new String[]{"*.ruta", "*.*"};
                    fd.setFilterExtensions(filterExt);
                    String file = fd.open();
                    if (file != null) {
                        preFileText.setText(file);
                    }
                }
            });
            this.skipPreButton = new Button((Composite)this, 16416);
            FormData skipPreButtonLData = new FormData();
            skipPreButtonLData.width = 50;
            skipPreButtonLData.height = 18;
            skipPreButtonLData.top = new FormAttachment(0, 1000, 92);
            skipPreButtonLData.right = new FormAttachment(1000, 1000, -25);
            this.skipPreButton.setLayoutData((Object)skipPreButtonLData);
            this.skipPreButton.setText("skip");
            this.label2 = new Label((Composite)this, 0);
            FormData label2LData = new FormData();
            label2LData.left = new FormAttachment(0, 1000, 12);
            label2LData.top = new FormAttachment(0, 1000, 116);
            label2LData.width = 109;
            this.label2.setLayoutData((Object)label2LData);
            this.label2.setText("Information Types:");
            this.slotTypes = new AddRemoveList("SlotTypes", this.images, this, true);
            FormData slotTypesLData = new FormData();
            slotTypesLData.width = 300;
            slotTypesLData.height = 144;
            slotTypesLData.top = new FormAttachment(0, 1000, 133);
            slotTypesLData.left = new FormAttachment(0, 1000, 12);
            this.slotTypes.setLayoutData(slotTypesLData);
            this.addDropTarget(this.slotTypes);
            this.filtersLabel = new Label((Composite)this, 0);
            FormData filtersLabeLData = new FormData();
            filtersLabeLData.width = 120;
            filtersLabeLData.left = new FormAttachment(0, 1000, 320);
            filtersLabeLData.top = new FormAttachment(0, 1000, 116);
            this.filtersLabel.setLayoutData((Object)filtersLabeLData);
            this.filtersLabel.setText("Filtered Feature Types:");
            this.filterTypes = new AddRemoveList("FilterTypes", this.images, this, false);
            FormData filterTypesLData = new FormData();
            filterTypesLData.width = 300;
            filterTypesLData.height = 144;
            filterTypesLData.top = new FormAttachment(0, 1000, 133);
            filterTypesLData.left = new FormAttachment(0, 1000, 320);
            this.filterTypes.setLayoutData(filterTypesLData);
            this.addDropTarget(this.filterTypes);
            FormData globalStatusLabeLData = new FormData();
            globalStatusLabeLData.width = 400;
            globalStatusLabeLData.left = new FormAttachment(0, 1000, 70);
            globalStatusLabeLData.top = new FormAttachment(0, 1000, 276);
            globalStatusLabeLData.right = new FormAttachment(1000, 1000, -19);
            this.globalStatusLabel = new Label((Composite)this, 0);
            this.globalStatusLabel.setLayoutData((Object)globalStatusLabeLData);
            this.methodsLabel = new Label((Composite)this, 0);
            FormData algsLabeLData = new FormData();
            algsLabeLData.width = 120;
            algsLabeLData.left = new FormAttachment(0, 1000, 12);
            algsLabeLData.top = new FormAttachment(0, 1000, 276);
            this.methodsLabel.setLayoutData((Object)algsLabeLData);
            this.methodsLabel.setText("Methods:");
            FormData algListViewerLData = new FormData();
            algListViewerLData.left = new FormAttachment(0, 1000, 10);
            algListViewerLData.top = new FormAttachment(0, 1000, 296);
            algListViewerLData.right = new FormAttachment(1000, 1000, -10);
            algListViewerLData.bottom = new FormAttachment(1000, 1000, -10);
            this.algListViewer = CheckboxTableViewer.newCheckList((Composite)this, (int)2816);
            this.algListViewer.getControl().setLayoutData((Object)algListViewerLData);
            this.algListViewer.setContentProvider((IContentProvider)new ListContentProvider());
            this.algListViewer.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider("learner"));
            this.algListViewer.setSorter((ViewerSorter)new NameSorter());
            if (this.textRulerView != null) {
                this.algListViewer.setInput((Object)this.textRulerView.getViewSite());
            }
            this.layout();
        }
        catch (Exception e) {
            TextRulerPlugin.error(e);
        }
        DropTarget dt = new DropTarget((Control)this.inputDirectoryText, 18);
        dt.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] fileList = null;
                FileTransfer ft = FileTransfer.getInstance();
                if (ft.isSupportedType(event.currentDataType)) {
                    fileList = (String[])event.data;
                }
                if (fileList.length > 0) {
                    TextRulerViewComposite.this.inputDirectoryText.setText(fileList[0]);
                }
            }
        });
        DropTarget dt3 = new DropTarget((Control)this.additionalDirectoryText, 18);
        dt3.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt3.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] fileList = null;
                FileTransfer ft = FileTransfer.getInstance();
                if (ft.isSupportedType(event.currentDataType)) {
                    fileList = (String[])event.data;
                }
                if (fileList.length > 0) {
                    TextRulerViewComposite.this.additionalDirectoryText.setText(fileList[0]);
                }
            }
        });
        DropTarget dt4 = new DropTarget((Control)this.testDirectoryText, 18);
        dt4.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt4.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] fileList = null;
                FileTransfer ft = FileTransfer.getInstance();
                if (ft.isSupportedType(event.currentDataType)) {
                    fileList = (String[])event.data;
                }
                if (fileList.length > 0) {
                    TextRulerViewComposite.this.testDirectoryText.setText(fileList[0]);
                }
            }
        });
        DropTarget dt2 = new DropTarget((Control)preFileText, 18);
        dt2.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt2.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] fileList = null;
                FileTransfer ft = FileTransfer.getInstance();
                if (ft.isSupportedType(event.currentDataType)) {
                    fileList = (String[])event.data;
                }
                if (fileList.length > 0) {
                    preFileText.setText(fileList[0]);
                }
            }
        });
        this.createAlgorithmConfigurators();
    }

    private void addDropTarget(final AddRemoveList list) {
        DropTarget fdt = new DropTarget((Control)list, 18);
        fdt.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        fdt.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] fileList = null;
                FileTransfer ft = FileTransfer.getInstance();
                if (ft.isSupportedType(event.currentDataType)) {
                    fileList = (String[])event.data;
                }
                if (fileList.length > 0) {
                    for (String string : fileList) {
                        if (string.endsWith(".xml")) {
                            TypeDescription[] typeDescs;
                            XMLizable descriptor = null;
                            try {
                                descriptor = UIMAFramework.getXMLParser().parse(new XMLInputSource(string));
                            }
                            catch (InvalidXMLException invalidXMLException) {
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (!(descriptor instanceof TypeSystemDescription)) continue;
                            TypeSystemDescription tsd = (TypeSystemDescription)descriptor;
                            try {
                                tsd.resolveImports();
                            }
                            catch (InvalidXMLException invalidXMLException) {
                                // empty catch block
                            }
                            ArrayList<String> tsTypes = new ArrayList<String>();
                            for (TypeDescription typeDescription : typeDescs = tsd.getTypes()) {
                                String n = typeDescription.getName();
                                tsTypes.add(n);
                            }
                            list.addAll(tsTypes);
                            continue;
                        }
                        if (!string.endsWith(".txt")) continue;
                        String file2String = null;
                        try {
                            file2String = FileUtils.file2String((File)new File(string), (String)"UTF-8");
                        }
                        catch (IOException tsd) {
                            // empty catch block
                        }
                        if (file2String == null) continue;
                        String replaceAll = file2String.replaceAll("[\\n\\r]+", ", ");
                        list.addAll(replaceAll);
                    }
                }
            }
        });
    }

    private void initImages() {
        this.images = new HashMap();
        ImageDescriptor desc = TextRulerPlugin.getImageDescriptor("/icons/add.png");
        Image image = desc.createImage();
        String name = "add";
        this.images.put(name, image);
        desc = TextRulerPlugin.getImageDescriptor("/icons/delete.png");
        image = desc.createImage();
        name = "delete";
        this.images.put(name, image);
        desc = TextRulerPlugin.getImageDescriptor("/icons/folder_edit.png");
        image = desc.createImage();
        name = "prepFolder";
        this.images.put(name, image);
        desc = TextRulerPlugin.getImageDescriptor("/icons/folder.png");
        image = desc.createImage();
        name = "folder";
        this.images.put(name, image);
        desc = TextRulerPlugin.getImageDescriptor("/icons/up.gif");
        image = desc.createImage();
        name = "up";
        this.images.put(name, image);
        desc = TextRulerPlugin.getImageDescriptor("/icons/down.gif");
        image = desc.createImage();
        name = "down";
        this.images.put(name, image);
        desc = TextRulerPlugin.getImageDescriptor("/icons/information.gif");
        image = desc.createImage();
        name = "information";
        this.images.put(name, image);
        desc = TextRulerPlugin.getImageDescriptor("/icons/feature.gif");
        image = desc.createImage();
        name = "feature";
        this.images.put(name, image);
        desc = TextRulerPlugin.getImageDescriptor("/icons/learner.png");
        image = desc.createImage();
        name = "learner";
        this.images.put(name, image);
        desc = TextRulerPlugin.getImageDescriptor("/icons/testing.gif");
        image = desc.createImage();
        name = "testing";
        this.images.put(name, image);
    }

    public Image getImage(String name) {
        if (this.images == null) {
            this.initImages();
        }
        return this.images.get(name);
    }

    public void dispose() {
        super.dispose();
        if (this.images != null) {
            for (Image each : this.images.values()) {
                each.dispose();
            }
        }
    }

    public String[] getFilters() {
        return this.filterTypes.getAll();
    }

    public String[] getSlotNames() {
        return this.slotTypes.getAll();
    }

    public String getPreprocessorTMFile() {
        return preFileText.getText().trim();
    }

    public String getInputDirectoryPath() {
        return this.inputDirectoryText.getText().trim();
    }

    public String getAdditionalDirectoryPath() {
        return this.additionalDirectoryText.getText().trim();
    }

    public String getTestDirectoryPath() {
        return this.testDirectoryText.getText().trim();
    }

    public CheckboxTableViewer getAlgListViewer() {
        return this.algListViewer;
    }

    public boolean getSkipPreprocessing() {
        return this.skipPreButton.getSelection();
    }

    public void setGlobalStatusString(String s) {
        this.globalStatusLabel.setText(s);
    }

    public void createAlgorithmConfigurators() {
        if (null == TextRulerController.getAvailableControllers()) {
            return;
        }
        for (TextRulerLearnerController ctrl : TextRulerController.getAvailableControllers()) {
            LearnerConfigurator ac = new LearnerConfigurator(ctrl);
            this.configurators.add(ac);
        }
    }

    public Map<String, Map<String, Object>> getCurrentAlgorithmParameters() {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (LearnerConfigurator c : this.configurators) {
            result.put(c.getID(), c.getCurrentParameterSettings());
        }
        return result;
    }

    public void saveState(IMemento memento) {
        IMemento activeAlgChild = memento.createChild("activeAlgorithms");
        for (Object c : this.algListViewer.getCheckedElements()) {
            activeAlgChild.createChild("algorithm", ((TextRulerLearnerController)c).getID());
        }
        memento.createChild("inputDirectory", this.inputDirectoryText.getText());
        memento.createChild("additionalDirectory", this.additionalDirectoryText.getText());
        memento.createChild("testDirectory", this.testDirectoryText.getText());
        memento.createChild("slotName", this.slotTypes.getAllElementsAsString());
        memento.createChild("filters", this.filterTypes.getAllElementsAsString());
        memento.createChild("preprocessFile", preFileText.getText());
        memento.createChild("skipPreprocessing", this.skipPreButton.getSelection() ? "yes" : "no");
        memento.createChild("showTest", this.showTestsButton.getSelection() ? "yes" : "no");
    }

    public LearnerConfigurator getAlgConfiguratorForID(String id) {
        for (LearnerConfigurator c : this.configurators) {
            if (!c.getID().equals(id)) continue;
            return c;
        }
        return null;
    }

    public void restoreState(IMemento memento) {
        IMemento skip;
        IMemento activeAlgs;
        IMemento test;
        IMemento additional;
        IMemento dir;
        IMemento preName;
        if (memento == null) {
            return;
        }
        IMemento filters = memento.getChild("filters");
        if (filters != null) {
            this.filterTypes.addAll(filters.getID());
        } else {
            this.filterTypes.addAll(TextRulerToolkit.getStandardFilterSetString());
        }
        IMemento slotName = memento.getChild("slotName");
        if (slotName != null) {
            this.slotTypes.addAll(slotName.getID());
        }
        if ((preName = memento.getChild("preprocessFile")) != null) {
            preFileText.setText(preName.getID());
        }
        if ((dir = memento.getChild("inputDirectory")) != null) {
            this.inputDirectoryText.setText(dir.getID());
        }
        if ((additional = memento.getChild("additionalDirectory")) != null) {
            this.additionalDirectoryText.setText(additional.getID());
        }
        if ((test = memento.getChild("testDirectory")) != null) {
            this.testDirectoryText.setText(test.getID());
        }
        if ((activeAlgs = memento.getChild("activeAlgorithms")) != null) {
            ArrayList<TextRulerLearnerController> activeControllers = new ArrayList<TextRulerLearnerController>();
            for (IMemento c : activeAlgs.getChildren("algorithm")) {
                TextRulerLearnerController ctrl = TextRulerController.getControllerForID(c.getID());
                if (ctrl == null) continue;
                activeControllers.add(ctrl);
            }
            this.algListViewer.setCheckedElements(activeControllers.toArray());
        }
        if ((skip = memento.getChild("skipPreprocessing")) != null) {
            boolean skipPreprocessing = skip.getID().equals("yes");
            this.skipPreButton.setSelection(skipPreprocessing);
        }
        IMemento showTest = memento.getChild("showTest");
        if (skip != null) {
            boolean showTestValue = showTest.getID().equals("yes");
            this.showTestsButton.setSelection(showTestValue);
        }
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.dirButton.setEnabled(flag);
        this.fileChooseButton.setEnabled(flag);
        this.slotTypes.setEnabled(flag);
        this.filterTypes.setEnabled(flag);
        preFileText.setEnabled(flag);
        this.inputDirectoryText.setEnabled(flag);
        this.additionalDirectoryText.setEnabled(flag);
        this.additionalButton.setEnabled(flag);
    }

    public static String getScriptPath() {
        return preFileText.getText();
    }

    public class DefaultLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final String type;

        public DefaultLabelProvider(String type) {
            this.type = type;
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            if (this.type.equals("SlotTypes")) {
                return (Image)TextRulerViewComposite.this.images.get("information");
            }
            if (this.type.equals("FilterTypes")) {
                return (Image)TextRulerViewComposite.this.images.get("feature");
            }
            if (this.type.equals("learner")) {
                return (Image)TextRulerViewComposite.this.images.get("learner");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }

    public class ListContentProvider
    implements IStructuredContentProvider {
        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return TextRulerController.getAvailableControllers().toArray();
        }
    }

    public class NameSorter
    extends ViewerSorter {
    }

    public class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

