/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.web;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.web.Log4jWebLifeCycle;
import org.apache.logging.log4j.web.WebLoggerContextUtils;

public class Log4jServletFilter
implements Filter {
    private static final Logger LOGGER = StatusLogger.getLogger();
    static final String ALREADY_FILTERED_ATTRIBUTE = Log4jServletFilter.class.getName() + ".FILTERED";
    private ServletContext servletContext;
    private Log4jWebLifeCycle initializer;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
        LOGGER.debug("Log4jServletFilter initialized.");
        this.initializer = WebLoggerContextUtils.getWebLifeCycle(this.servletContext);
        this.initializer.clearLoggerContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getAttribute(ALREADY_FILTERED_ATTRIBUTE) != null) {
            chain.doFilter(request, response);
        } else {
            request.setAttribute(ALREADY_FILTERED_ATTRIBUTE, (Object)Boolean.TRUE);
            try {
                this.initializer.setLoggerContext();
                chain.doFilter(request, response);
            }
            finally {
                this.initializer.clearLoggerContext();
                request.removeAttribute(ALREADY_FILTERED_ATTRIBUTE);
            }
        }
    }

    public void destroy() {
        if (this.servletContext == null || this.initializer == null) {
            throw new IllegalStateException("Filter destroyed before it was initialized.");
        }
        LOGGER.debug("Log4jServletFilter destroyed.");
        this.initializer.setLoggerContext();
    }
}

