/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.serializer.impl;

import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;

public class PrimitiveSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 2L;
    private static Class[] _serializableClasses = new Class[]{Integer.TYPE, Byte.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static Class[] _JSONClasses = new Class[]{Integer.class, Byte.class, Short.class, Long.class, Float.class, Double.class, String.class};

    @Override
    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    @Override
    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public Object toPrimitive(Class clazz, Object jso) throws NumberFormatException {
        if (Integer.TYPE.equals(clazz)) {
            if (jso instanceof String) {
                return Integer.valueOf((String)jso);
            }
            Number n = (Number)jso;
            if (n.longValue() != (long)n.intValue()) {
                throw new NumberFormatException("number is too large for an int");
            }
            if (n.floatValue() != (float)n.intValue()) {
                throw new NumberFormatException("number is not an integer");
            }
            return n.intValue();
        }
        if (Long.TYPE.equals(clazz)) {
            if (jso instanceof String) {
                return Long.valueOf((String)jso);
            }
            Number n = (Number)jso;
            if (n.floatValue() != (float)n.longValue()) {
                throw new NumberFormatException("number is not an integer");
            }
            return n.longValue();
        }
        if (Short.TYPE.equals(clazz)) {
            if (jso instanceof String) {
                return Short.valueOf((String)jso);
            }
            Number n = (Number)jso;
            if (n.longValue() != (long)n.shortValue()) {
                throw new NumberFormatException("number is too large for an short");
            }
            if (n.floatValue() != (float)n.shortValue()) {
                throw new NumberFormatException("number is not an integer");
            }
            return n.shortValue();
        }
        if (Byte.TYPE.equals(clazz)) {
            if (jso instanceof String) {
                return Byte.valueOf((String)jso);
            }
            Number n = (Number)jso;
            if (n.longValue() != (long)n.byteValue()) {
                throw new NumberFormatException("number is too large for an short");
            }
            if (n.floatValue() != (float)n.byteValue()) {
                throw new NumberFormatException("number is not an integer");
            }
            return n.byteValue();
        }
        if (Float.TYPE.equals(clazz)) {
            if (jso instanceof String) {
                return Float.valueOf((String)jso);
            }
            Number n = (Number)jso;
            if (n.floatValue() > Float.MAX_VALUE || n.floatValue() < -3.4028235E38f) {
                throw new NumberFormatException("number is too large for a float");
            }
            return Float.valueOf(((Number)jso).floatValue());
        }
        if (Double.TYPE.equals(clazz)) {
            if (jso instanceof String) {
                return Double.valueOf((String)jso);
            }
            return ((Number)jso).doubleValue();
        }
        return null;
    }

    @Override
    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        try {
            this.toPrimitive(clazz, jso);
        }
        catch (NumberFormatException e) {
            throw new UnmarshallException("not a primitive", e);
        }
        state.setSerialized(jso, ObjectMatch.OKAY);
        return ObjectMatch.OKAY;
    }

    @Override
    public Object unmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        try {
            Object primitive = this.toPrimitive(clazz, jso);
            state.setSerialized(jso, primitive);
            return primitive;
        }
        catch (NumberFormatException e) {
            throw new UnmarshallException("cannot convert object " + String.valueOf(jso) + " to type " + clazz.getName(), e);
        }
    }

    @Override
    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        return o;
    }
}

