/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.calculate;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import nl.basjes.collections.PrefixMap;
import nl.basjes.collections.prefixmap.StringPrefixMap;
import nl.basjes.parse.useragent.AgentField;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.calculate.FieldCalculator;
import nl.basjes.parse.useragent.config.AnalyzerConfigHolder;
import nl.basjes.parse.useragent.utils.HostnameExtracter;
import nl.basjes.parse.useragent.utils.Normalize;
import nl.basjes.parse.useragent.utils.WordSplitter;
import nl.basjes.parse.useragent.yauaa.shaded.org.apache.commons.lang3.tuple.Pair;

public class CalculateDeviceBrand
extends FieldCalculator {
    private final PrefixMap<String> mobileBrandPrefixes = new StringPrefixMap(false);
    private static final List<String> GENERIC_DEVICE_NAMES = Arrays.asList("Unknown", "android mobile", "fuchsia mobile", "fuchsia device", "ios device", "linux desktop", "desktop", "laptop", "server", "phone", "tv", "imitator", "bot", "tablet", "mobile", "device", "generic", "windows", "linux", "android", "ios", "fuchsia");

    public CalculateDeviceBrand() {
    }

    public CalculateDeviceBrand(AnalyzerConfigHolder analyzerConfig) {
        Map<String, String> mobileBrandPrefixesLookup;
        Map<String, String> mobileBrandsLookup = analyzerConfig.getLookups().get("MobileBrands");
        if (mobileBrandsLookup != null) {
            this.mobileBrandPrefixes.putAll(mobileBrandsLookup);
        }
        if ((mobileBrandPrefixesLookup = analyzerConfig.getLookups().get("MobileBrandPrefixes")) != null) {
            this.mobileBrandPrefixes.putAll(mobileBrandPrefixesLookup);
        }
    }

    @Override
    public void calculate(UserAgent.MutableUserAgent userAgent) {
        AgentField.MutableAgentField deviceBrand = userAgent.get("DeviceBrand");
        if (deviceBrand.isDefaultValue()) {
            AgentField.MutableAgentField deviceName = userAgent.get("DeviceName");
            String newDeviceBrand = (String)((Object)this.mobileBrandPrefixes.getLongestMatch(deviceName.getValue()));
            if (newDeviceBrand != null) {
                userAgent.setForced("DeviceBrand", newDeviceBrand, 0L);
                return;
            }
            newDeviceBrand = this.determineDeviceBrand(userAgent);
            userAgent.setForced("DeviceBrand", newDeviceBrand == null ? "<<<null>>>" : newDeviceBrand, 0L);
        } else {
            userAgent.setForced("DeviceBrand", Normalize.brand(deviceBrand.getValue()), deviceBrand.getConfidence());
        }
    }

    private String determineDeviceBrand(UserAgent userAgent) {
        List<Pair<Integer, Integer>> splitList;
        String deviceBrand = null;
        AgentField informationUrl = userAgent.get("AgentInformationUrl");
        if (!informationUrl.isDefaultValue()) {
            deviceBrand = HostnameExtracter.extractBrandFromUrl(informationUrl.getValue());
        }
        if (deviceBrand != null) {
            return deviceBrand;
        }
        AgentField informationEmail = userAgent.get("AgentInformationEmail");
        if (!informationEmail.isDefaultValue()) {
            deviceBrand = HostnameExtracter.extractBrandFromEmail(informationEmail.getValue());
        }
        if (deviceBrand != null) {
            return deviceBrand;
        }
        AgentField deviceName = userAgent.get("DeviceName");
        if (!deviceName.isDefaultValue() && !GENERIC_DEVICE_NAMES.contains(deviceName.getValue()) && (splitList = WordSplitter.getInstance().createSplitList(deviceName.getValue())).size() > 1) {
            List<String> splits = WordSplitter.getInstance().getSplits(deviceName.getValue(), splitList, 1, 5);
            boolean update = true;
            for (String split : splits) {
                if (!GENERIC_DEVICE_NAMES.contains(split.toLowerCase(Locale.ROOT))) continue;
                update = false;
                break;
            }
            if (update) {
                deviceBrand = Normalize.brand(splits.get(0));
            }
        }
        return deviceBrand;
    }

    @Override
    public String getCalculatedFieldName() {
        return "DeviceBrand";
    }

    @Override
    public Set<String> getDependencies() {
        return new HashSet<String>(Arrays.asList("AgentInformationUrl", "AgentInformationEmail"));
    }
}

