/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.urlmapper;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration2.Configuration;
import org.apache.fulcrum.parser.ParameterParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.servlet.ServletService;
import org.apache.turbine.services.urlmapper.URLMapperService;
import org.apache.turbine.services.urlmapper.model.URLMapEntry;
import org.apache.turbine.services.urlmapper.model.URLMappingContainer;
import org.apache.turbine.util.uri.TurbineURI;
import org.apache.turbine.util.uri.URIParam;

public class TurbineURLMapperService
extends TurbineBaseService
implements URLMapperService {
    private static final Logger log = LogManager.getLogger(TurbineURLMapperService.class);
    private static final String DEFAULT_CONFIGURATION_FILE = "/WEB-INF/conf/turbine-url-mapping.xml";
    private static final String CONFIGURATION_FILE_KEY = "configFile";
    private URLMappingContainer container;
    private static final Pattern NAMED_GROUPS_PATTERN = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>.+?\\)");
    private static final Pattern MULTI_SLASH_PATTERN = Pattern.compile("[/]+");
    private static final String CONTEXT_PATH_PARAMETER = "contextPath";
    private static final String WEBAPP_ROOT_PARAMETER = "webAppRoot";
    private static final Set<String> DEFAULT_PARAMETERS = new HashSet<String>(Arrays.asList("contextPath", "webAppRoot"));

    @Override
    public void mapToURL(TurbineURI uri) {
        if (!uri.hasPathInfo() && !uri.hasQueryData()) {
            return;
        }
        List<URIParam> pathInfo = uri.getPathInfo();
        List<URIParam> queryData = uri.getQueryData();
        Map uriParameterMap = Stream.concat(pathInfo.stream(), queryData.stream()).collect(Collectors.toMap(URIParam::getKey, URIParam::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        for (URLMapEntry urlMap : this.container.getMapEntries()) {
            HashSet keys = new HashSet(uriParameterMap.keySet());
            keys.removeAll(urlMap.getIgnoreParameters().keySet());
            HashSet<String> entryKeys = new HashSet<String>(urlMap.getGroupNamesMap().keySet());
            Set<String> implicitKeysFound = urlMap.getImplicitParameters().entrySet().stream().filter(entry -> Objects.equals(uriParameterMap.get(entry.getKey()), entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
            entryKeys.addAll(implicitKeysFound);
            if (!entryKeys.containsAll(keys)) continue;
            Matcher matcher = NAMED_GROUPS_PATTERN.matcher(urlMap.getUrlPattern().pattern());
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String key2 = matcher.group(1);
                if (CONTEXT_PATH_PARAMETER.equals(key2)) {
                    matcher.appendReplacement(sb, "");
                    continue;
                }
                if (WEBAPP_ROOT_PARAMETER.equals(key2)) {
                    matcher.appendReplacement(sb, uri.getScriptName());
                    continue;
                }
                boolean ignore = urlMap.getIgnoreParameters().keySet().stream().anyMatch(x -> x.equals(key2));
                matcher.appendReplacement(sb, Matcher.quoteReplacement(!ignore ? Objects.toString(uriParameterMap.get(key2)) : ""));
                pathInfo.removeIf(uriParam -> key2.equals(uriParam.getKey()));
                queryData.removeIf(uriParam -> key2.equals(uriParam.getKey()));
            }
            matcher.appendTail(sb);
            implicitKeysFound.forEach(key -> {
                pathInfo.removeIf(uriParam -> key.equals(uriParam.getKey()));
                queryData.removeIf(uriParam -> key.equals(uriParam.getKey()));
            });
            uri.setScriptName(MULTI_SLASH_PATTERN.matcher(sb).replaceAll("/").replaceFirst("/$", ""));
            break;
        }
        log.debug("mapped to uri: {} ", (Object)uri);
    }

    @Override
    public void mapFromURL(String url, ParameterParser pp) {
        for (URLMapEntry urlMap : this.container.getMapEntries()) {
            url = url.replaceFirst("/$", "");
            Matcher matcher = urlMap.getUrlPattern().matcher(url);
            if (!matcher.matches()) continue;
            urlMap.getGroupNamesMap().entrySet().stream().filter(group -> !DEFAULT_PARAMETERS.contains(group.getKey())).forEach(group -> pp.setString((String)group.getKey(), matcher.group((Integer)group.getValue())));
            urlMap.getImplicitParameters().forEach((arg_0, arg_1) -> ((ParameterParser)pp).add(arg_0, arg_1));
            urlMap.getOverrideParameters().forEach((arg_0, arg_1) -> ((ParameterParser)pp).setString(arg_0, arg_1));
            urlMap.getIgnoreParameters().keySet().forEach(arg_0 -> ((ParameterParser)pp).remove(arg_0));
            log.debug("mapped {} params from url {} ", (Object)pp.getKeys().length, (Object)url);
            break;
        }
    }

    @Override
    public void init() throws InitializationException {
        Configuration cfg = this.getConfiguration();
        Object configFile = cfg.getString(CONFIGURATION_FILE_KEY, DEFAULT_CONFIGURATION_FILE);
        if (!((String)configFile).startsWith("/")) {
            configFile = "/" + (String)configFile;
        }
        ServletService servletService = (ServletService)TurbineServices.getInstance().getService("ServletService");
        try (InputStream reader = servletService.getResourceAsStream((String)configFile);){
            ObjectMapper mapper;
            if (((String)configFile).endsWith(".xml")) {
                JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{URLMappingContainer.class});
                Unmarshaller unmarshaller = jaxb.createUnmarshaller();
                this.container = (URLMappingContainer)unmarshaller.unmarshal(reader);
            } else if (((String)configFile).endsWith(".yml")) {
                mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                this.container = (URLMappingContainer)mapper.readValue(reader, URLMappingContainer.class);
            } else if (((String)configFile).endsWith(".json")) {
                mapper = JsonMapper.builder().build();
                this.container = (URLMappingContainer)mapper.readValue(reader, URLMappingContainer.class);
            }
        }
        catch (JAXBException | IOException e) {
            throw new InitializationException("Could not load configuration file " + (String)configFile, e);
        }
        for (URLMapEntry urlMap : this.container.getMapEntries()) {
            int position = 1;
            HashMap<String, Integer> groupNamesMap = new HashMap<String, Integer>();
            Matcher matcher = NAMED_GROUPS_PATTERN.matcher(urlMap.getUrlPattern().pattern());
            while (matcher.find()) {
                groupNamesMap.put(matcher.group(1), position++);
            }
            urlMap.setGroupNamesMap(groupNamesMap);
        }
        log.info("Loaded {} url-mappings from {}", (Object)this.container.getMapEntries().size(), configFile);
        this.setInit(true);
    }

    @Override
    public void shutdown() {
        this.container.getMapEntries().clear();
        this.setInit(false);
    }
}

