/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.fulcrum.parser.BaseValueParser;
import org.apache.fulcrum.parser.DefaultCookieParser;
import org.apache.fulcrum.parser.DefaultParameterParser;
import org.apache.fulcrum.parser.ParserService;
import org.apache.fulcrum.parser.ParserServiceSupport;
import org.apache.fulcrum.parser.ValueParser;
import org.apache.fulcrum.parser.pool.BaseValueParserFactory;
import org.apache.fulcrum.parser.pool.BaseValueParserPool;
import org.apache.fulcrum.parser.pool.CookieParserFactory;
import org.apache.fulcrum.parser.pool.CookieParserPool;
import org.apache.fulcrum.parser.pool.DefaultParameterParserFactory;
import org.apache.fulcrum.parser.pool.DefaultParameterParserPool;

public class DefaultParserService
extends AbstractLogEnabled
implements ParserService,
Configurable,
Serviceable {
    private ValueParser.URLCaseFolding folding = ValueParser.URLCaseFolding.NONE;
    private boolean automaticUpload = false;
    private String parameterEncoding = "ISO-8859-1";
    int DEFAULT_POOL_CAPACITY = 1024;
    private BaseValueParserPool valueParserPool;
    private DefaultParameterParserPool parameterParserPool;
    private CookieParserPool cookieParserPool;

    public DefaultParserService() {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxIdle(1);
        config.setMaxTotal(this.DEFAULT_POOL_CAPACITY);
        this.valueParserPool = new BaseValueParserPool((PooledObjectFactory<BaseValueParser>)new BaseValueParserFactory(), config);
        this.parameterParserPool = new DefaultParameterParserPool((PooledObjectFactory<DefaultParameterParser>)new DefaultParameterParserFactory(), config);
        this.cookieParserPool = new CookieParserPool((PooledObjectFactory<DefaultCookieParser>)new CookieParserFactory(), config);
    }

    public DefaultParserService(GenericObjectPoolConfig<?> config) {
        this.valueParserPool = new BaseValueParserPool((PooledObjectFactory<BaseValueParser>)new BaseValueParserFactory(), config);
        this.parameterParserPool = new DefaultParameterParserPool((PooledObjectFactory<DefaultParameterParser>)new DefaultParameterParserFactory(), config);
    }

    @Override
    public String getParameterEncoding() {
        return this.parameterEncoding;
    }

    @Override
    public String convert(String value) {
        return this.convertAndTrim(value);
    }

    @Override
    public String convertAndTrim(String value) {
        return this.convertAndTrim(value, this.getUrlFolding());
    }

    @Override
    public String convertAndTrim(String value, ValueParser.URLCaseFolding fold) {
        if (value == null) {
            return "";
        }
        String tmp = value.trim();
        switch (fold) {
            case NONE: {
                break;
            }
            case LOWER: {
                tmp = tmp.toLowerCase();
                break;
            }
            case UPPER: {
                tmp = tmp.toUpperCase();
                break;
            }
            default: {
                this.getLogger().error("Passed " + (Object)((Object)fold) + " as fold rule, which is illegal!");
            }
        }
        return tmp;
    }

    @Override
    public ValueParser.URLCaseFolding getUrlFolding() {
        return this.folding;
    }

    @Override
    public boolean getAutomaticUpload() {
        return this.automaticUpload;
    }

    @Override
    public List<Part> parseUpload(HttpServletRequest request) throws ServiceException {
        try {
            return new ArrayList<Part>(request.getParts());
        }
        catch (IOException | ServletException e) {
            throw new ServiceException(ParserService.ROLE, "Could not parse upload request", e);
        }
    }

    @Override
    public <P extends ValueParser> P getParser(Class<P> ppClass) throws InstantiationException {
        BaseValueParser vp = null;
        try {
            BaseValueParser parserInstance;
            if (ppClass.equals(BaseValueParser.class)) {
                try {
                    vp = parserInstance = (BaseValueParser)this.valueParserPool.borrowObject();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (ppClass.equals(DefaultParameterParser.class)) {
                try {
                    vp = parserInstance = (DefaultParameterParser)this.parameterParserPool.borrowObject();
                }
                catch (Exception parserInstance2) {
                    // empty catch block
                }
            }
            if (ppClass.equals(DefaultCookieParser.class)) {
                try {
                    vp = parserInstance = (DefaultCookieParser)this.cookieParserPool.borrowObject();
                }
                catch (Exception parserInstance3) {
                    // empty catch block
                }
            }
            ((ParserServiceSupport)vp).setParserService(this);
            ((LogEnabled)vp).enableLogging(this.getLogger().getChildLogger(ppClass.getSimpleName()));
        }
        catch (ClassCastException x) {
            throw new InstantiationException("Parser class '" + ppClass + "' is illegal. " + x.getMessage());
        }
        return (P)vp;
    }

    @Override
    public void putParser(ValueParser parser) {
        parser.clear();
        if (parser.getClass().isInstance(BaseValueParser.class)) {
            this.valueParserPool.returnObject((BaseValueParser)parser);
        }
        if (parser.getClass().isInstance(DefaultParameterParser.class)) {
            this.parameterParserPool.returnObject((DefaultParameterParser)parser);
        }
        if (parser.getClass().isInstance(DefaultCookieParser.class)) {
            this.cookieParserPool.returnObject((DefaultCookieParser)parser);
        }
    }

    public void configure(Configuration conf) throws ConfigurationException {
        String foldString = conf.getChild("urlCaseFolding").getValue(ValueParser.URLCaseFolding.NONE.name()).toLowerCase();
        this.folding = ValueParser.URLCaseFolding.NONE;
        this.getLogger().debug("Setting folding from " + foldString);
        if (StringUtils.isNotEmpty((CharSequence)foldString)) {
            try {
                this.folding = ValueParser.URLCaseFolding.valueOf(foldString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.getLogger().error("Got " + foldString + " from " + "urlCaseFolding" + " property, which is illegal!");
                throw new ConfigurationException("Value " + foldString + " is illegal!", (Throwable)e);
            }
        }
        this.parameterEncoding = conf.getChild("parameterEncoding").getValue("ISO-8859-1").toLowerCase();
        this.automaticUpload = conf.getChild("automaticUpload").getValueAsBoolean(false);
    }

    public void service(ServiceManager manager) throws ServiceException {
    }
}

