/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.exception;

import java.lang.annotation.Annotation;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.qualitycheck.ArgumentsChecked;
import net.sf.qualitycheck.Throws;
import net.sf.qualitycheck.exception.IllegalNullArgumentException;

public class IllegalMissingAnnotationException
extends RuntimeException {
    private static final long serialVersionUID = -8428891146741574807L;
    protected static final String DEFAULT_MESSAGE = "Annotation is required on the passed class.";
    protected static final String MESSAGE_WITH_ANNOTATION = "Class must have annotation '%s'.";
    protected static final String MESSAGE_WITH_ANNOTATION_AND_CLASS = "Class '%s' must have annotation '%s'.";
    @Nullable
    private final Class<? extends Annotation> annotation;
    @Nullable
    private final Class<?> clazz;

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class})
    private static String format(@Nonnull Class<? extends Annotation> annotation) {
        if (annotation == null) {
            throw new IllegalNullArgumentException("annotation");
        }
        return String.format(MESSAGE_WITH_ANNOTATION, annotation.getName());
    }

    @ArgumentsChecked
    @Throws(value={IllegalNullArgumentException.class})
    private static String format(@Nonnull Class<? extends Annotation> annotation, @Nullable Class<?> clazz) {
        if (annotation == null) {
            throw new IllegalNullArgumentException("annotation");
        }
        if (clazz != null) {
            return String.format(MESSAGE_WITH_ANNOTATION_AND_CLASS, clazz.getName(), annotation.getName());
        }
        return IllegalMissingAnnotationException.format(annotation);
    }

    public IllegalMissingAnnotationException() {
        super(DEFAULT_MESSAGE);
        this.annotation = null;
        this.clazz = null;
    }

    public IllegalMissingAnnotationException(@Nonnull Class<? extends Annotation> annotation) {
        super(IllegalMissingAnnotationException.format(annotation));
        this.annotation = annotation;
        this.clazz = null;
    }

    public IllegalMissingAnnotationException(@Nonnull Class<? extends Annotation> annotation, @Nullable Throwable cause) {
        super(IllegalMissingAnnotationException.format(annotation), cause);
        this.annotation = annotation;
        this.clazz = null;
    }

    public IllegalMissingAnnotationException(@Nonnull Class<? extends Annotation> annotation, @Nullable Class<?> clazz) {
        super(IllegalMissingAnnotationException.format(annotation, clazz));
        this.annotation = annotation;
        this.clazz = clazz;
    }

    public IllegalMissingAnnotationException(@Nonnull Class<? extends Annotation> annotation, @Nullable Class<?> clazz, @Nullable Throwable cause) {
        super(IllegalMissingAnnotationException.format(annotation, clazz), cause);
        this.annotation = annotation;
        this.clazz = clazz;
    }

    public IllegalMissingAnnotationException(@Nullable Throwable cause) {
        super(DEFAULT_MESSAGE, cause);
        this.annotation = null;
        this.clazz = null;
    }

    public Class<? extends Annotation> getMissingAnnotation() {
        return this.annotation;
    }

    public Class<?> getClassWithoutAnnotation() {
        return this.clazz;
    }
}

