/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.template;

import java.util.Hashtable;
import org.apache.commons.configuration.Configuration;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.template.TemplateEngineService;
import org.apache.turbine.services.template.TemplateService;

public abstract class BaseTemplateEngineService
extends TurbineBaseService
implements TemplateEngineService {
    private final Hashtable<String, Object> configuration = new Hashtable();

    @Override
    public void registerConfiguration(String defaultExt) {
        this.initConfiguration(defaultExt);
        TemplateService templateService = (TemplateService)TurbineServices.getInstance().getService("TemplateService");
        templateService.registerTemplateEngineService(this);
    }

    @Override
    public Hashtable<String, Object> getTemplateEngineServiceConfiguration() {
        return this.configuration;
    }

    @Override
    public String[] getAssociatedFileExtensions() {
        return (String[])this.configuration.get("template.extension");
    }

    protected void initConfiguration(String defaultExt) {
        Configuration config = this.getConfiguration();
        String[] fileExtensionAssociations = config.getStringArray("template.extension");
        if (fileExtensionAssociations == null || fileExtensionAssociations.length == 0) {
            fileExtensionAssociations = new String[]{config.getString("template.default.extension", defaultExt)};
        }
        this.configuration.put("template.extension", fileExtensionAssociations);
        String[] copyParams = new String[]{"default.page", "default.screen", "default.layout", "default.navigation", "default.error.screen", "default.layout.template", "default.screen.template"};
        for (int i = 0; i < copyParams.length; ++i) {
            this.configuration.put(copyParams[i], config.getString(copyParams[i], ""));
        }
    }

    @Override
    public abstract boolean templateExists(String var1);
}

