/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.data.domain;

import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.UserAgent;
import net.sf.uadetector.UserAgentFamily;
import net.sf.uadetector.UserAgentType;
import net.sf.uadetector.internal.data.domain.Identifiable;

@Immutable
public final class Robot
implements Identifiable,
Serializable {
    private static final long serialVersionUID = -605392434061575985L;
    public static final String TYPENAME = "Robot";
    @Nonnull
    private final UserAgentFamily family;
    @Nonnull
    private final String familyName;
    private final int hash;
    @Nonnull
    private final String icon;
    @Nonnegative
    private final int id;
    @Nonnull
    private final String infoUrl;
    @Nonnull
    private final String name;
    @Nonnull
    private final String producer;
    @Nonnull
    private final String producerUrl;
    @Nonnull
    private final String userAgentString;

    private static int buildHashCode(@Nonnegative int id, @Nonnull String name, @Nonnull UserAgentFamily family, @Nonnull String familyName, @Nonnull String infoUrl, @Nonnull String producer, @Nonnull String producerUrl, @Nonnull String userAgentString, @Nonnull String icon) {
        int prime = 31;
        int result = 1;
        result = 31 * result + id;
        result = 31 * result + name.hashCode();
        result = 31 * result + family.hashCode();
        result = 31 * result + familyName.hashCode();
        result = 31 * result + infoUrl.hashCode();
        result = 31 * result + producer.hashCode();
        result = 31 * result + producerUrl.hashCode();
        result = 31 * result + userAgentString.hashCode();
        result = 31 * result + icon.hashCode();
        return result;
    }

    public Robot(@Nonnegative int id, @Nonnull String name, @Nonnull UserAgentFamily family, @Nonnull String familyName, @Nonnull String infoUrl, @Nonnull String producer, @Nonnull String producerUrl, @Nonnull String userAgentString, @Nonnull String icon) {
        this.id = Check.notNegative((int)id, (String)"id");
        this.name = (String)Check.notNull((Object)name, (String)"name");
        this.family = (UserAgentFamily)((Object)Check.notNull((Object)((Object)family), (String)"family"));
        this.familyName = (String)Check.notNull((Object)familyName, (String)"familyName");
        this.infoUrl = (String)Check.notNull((Object)infoUrl, (String)"infoUrl");
        this.producer = (String)Check.notNull((Object)producer, (String)"producer");
        this.producerUrl = (String)Check.notNull((Object)producerUrl, (String)"producerUrl");
        this.userAgentString = (String)Check.notNull((Object)userAgentString, (String)"userAgentString");
        this.icon = (String)Check.notNull((Object)icon, (String)"icon");
        this.hash = Robot.buildHashCode(id, name, family, familyName, infoUrl, producer, producerUrl, userAgentString, icon);
    }

    public void copyTo(@Nonnull UserAgent.Builder builder) {
        builder.setFamily(this.family);
        builder.setIcon(this.icon);
        builder.setName(this.name);
        builder.setProducer(this.producer);
        builder.setProducerUrl(this.producerUrl);
        builder.setUrl(this.infoUrl);
        builder.setType(UserAgentType.ROBOT);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Robot other = (Robot)obj;
        if (this.id != other.id) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!this.family.equals((Object)other.family)) {
            return false;
        }
        if (!this.familyName.equals(other.familyName)) {
            return false;
        }
        if (!this.infoUrl.equals(other.infoUrl)) {
            return false;
        }
        if (!this.producer.equals(other.producer)) {
            return false;
        }
        if (!this.producerUrl.equals(other.producerUrl)) {
            return false;
        }
        if (!this.userAgentString.equals(other.userAgentString)) {
            return false;
        }
        return this.icon.equals(other.icon);
    }

    @Nonnull
    public UserAgentFamily getFamily() {
        return this.family;
    }

    @Nonnull
    public String getFamilyName() {
        return this.familyName;
    }

    @Nonnull
    public String getIcon() {
        return this.icon;
    }

    @Override
    @Nonnegative
    public int getId() {
        return this.id;
    }

    @Nonnull
    public String getInfoUrl() {
        return this.infoUrl;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getProducer() {
        return this.producer;
    }

    @Nonnull
    public String getProducerUrl() {
        return this.producerUrl;
    }

    @Nonnull
    public String getUserAgentString() {
        return this.userAgentString;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ReadableRobot [id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", family=");
        builder.append((Object)this.family);
        builder.append(", familyName=");
        builder.append(this.familyName);
        builder.append(", infoUrl=");
        builder.append(this.infoUrl);
        builder.append(", producer=");
        builder.append(this.producer);
        builder.append(", producerUrl=");
        builder.append(this.producerUrl);
        builder.append(", userAgentString=");
        builder.append(this.userAgentString);
        builder.append(", icon=");
        builder.append(this.icon);
        builder.append("]");
        return builder.toString();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final String EMPTY = "";
        @Nonnull
        private UserAgentFamily family = UserAgentFamily.UNKNOWN;
        @Nonnull
        private String familyName = "";
        @Nonnull
        private String icon = "";
        private int id = Integer.MIN_VALUE;
        @Nonnull
        private String infoUrl = "";
        @Nonnull
        private String name = "";
        @Nonnull
        private String producer = "";
        @Nonnull
        private String producerUrl = "";
        @Nonnull
        private String userAgentString = "";

        public Builder() {
        }

        public Builder(@Nonnull Robot robot) {
            Check.notNull((Object)robot, (String)"robot");
            this.id = Check.notNegative((int)robot.getId(), (String)"robot.getId()");
            this.name = (String)Check.notNull((Object)robot.getName(), (String)"robot.getName()");
            this.family = (UserAgentFamily)((Object)Check.notNull((Object)((Object)robot.getFamily()), (String)"robot.getFamily()"));
            this.familyName = (String)Check.notNull((Object)robot.getFamilyName(), (String)"robot.getFamilyName()");
            this.infoUrl = (String)Check.notNull((Object)robot.getInfoUrl(), (String)"robot.getInfoUrl()");
            this.producer = (String)Check.notNull((Object)robot.getProducer(), (String)"robot.getProducer()");
            this.producerUrl = (String)Check.notNull((Object)robot.getProducerUrl(), (String)"robot.getProducerUrl()");
            this.userAgentString = (String)Check.notNull((Object)robot.getUserAgentString(), (String)"robot.getUserAgentString()");
            this.icon = (String)Check.notNull((Object)robot.getIcon(), (String)"robot.getIcon()");
        }

        @Nonnull
        public Robot build() {
            return new Robot(this.id, this.name, this.family, this.familyName, this.infoUrl, this.producer, this.producerUrl, this.userAgentString, this.icon);
        }

        @Nonnull
        public Builder setFamilyName(@Nonnull String familyName) {
            this.familyName = (String)Check.notNull((Object)familyName, (String)"familyName");
            this.family = UserAgentFamily.evaluate(familyName);
            return this;
        }

        @Nonnull
        public Builder setIcon(@Nonnull String icon) {
            this.icon = (String)Check.notNull((Object)icon, (String)"icon");
            return this;
        }

        @Nonnull
        public Builder setId(@Nonnegative int id) {
            this.id = Check.notNegative((int)id, (String)"id");
            return this;
        }

        @Nonnull
        public Builder setId(@Nonnull String id) {
            this.id = Integer.parseInt((String)Check.notEmpty((CharSequence)id, (String)"id"));
            return this;
        }

        @Nonnull
        public Builder setInfoUrl(@Nonnull String infoUrl) {
            this.infoUrl = (String)Check.notNull((Object)infoUrl, (String)"infoUrl");
            return this;
        }

        @Nonnull
        public Builder setName(@Nonnull String name) {
            this.name = (String)Check.notNull((Object)name, (String)"name");
            return this;
        }

        @Nonnull
        public Builder setProducer(@Nonnull String producer) {
            this.producer = (String)Check.notNull((Object)producer, (String)"producer");
            return this;
        }

        @Nonnull
        public Builder setProducerUrl(@Nonnull String producerUrl) {
            this.producerUrl = (String)Check.notNull((Object)producerUrl, (String)"producerUrl");
            return this;
        }

        @Nonnull
        public Builder setUserAgentString(@Nonnull String userAgentString) {
            this.userAgentString = (String)Check.notNull((Object)userAgentString, (String)"userAgentString");
            return this;
        }
    }
}

