/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerData {
    private String serverName = null;
    private int serverPort = 0;
    private String serverScheme = null;
    private String scriptName = null;
    private String contextPath = null;
    private static Log log = LogFactory.getLog(ServerData.class);

    public ServerData(String serverName, int serverPort, String serverScheme, String scriptName, String contextPath) {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constructor(");
            sb.append(serverName);
            sb.append(", ");
            sb.append(serverPort);
            sb.append(", ");
            sb.append(serverScheme);
            sb.append(", ");
            sb.append(scriptName);
            sb.append(", ");
            sb.append(contextPath);
            sb.append(")");
            log.debug((Object)sb.toString());
        }
        this.setServerName(serverName);
        this.setServerPort(serverPort);
        this.setServerScheme(serverScheme);
        this.setScriptName(scriptName);
        this.setContextPath(contextPath);
    }

    public ServerData(ServerData serverData) {
        log.debug((Object)("Copy Constructor(" + serverData + ")"));
        this.setServerName(serverData.getServerName());
        this.setServerPort(serverData.getServerPort());
        this.setServerScheme(serverData.getServerScheme());
        this.setScriptName(serverData.getScriptName());
        this.setContextPath(serverData.getContextPath());
    }

    public ServerData(HttpServletRequest req) {
        this.setServerName(req.getServerName());
        this.setServerPort(req.getServerPort());
        this.setServerScheme(req.getScheme());
        this.setScriptName(req.getServletPath());
        this.setContextPath(req.getContextPath());
    }

    public Object clone() {
        log.debug((Object)"clone()");
        return new ServerData(this);
    }

    public String getServerName() {
        return StringUtils.isEmpty((String)this.serverName) ? "" : this.serverName;
    }

    public void setServerName(String serverName) {
        log.debug((Object)("setServerName(" + serverName + ")"));
        this.serverName = serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        log.debug((Object)("setServerPort(" + serverPort + ")"));
        this.serverPort = serverPort;
    }

    public String getServerScheme() {
        return StringUtils.isEmpty((String)this.serverScheme) ? "" : this.serverScheme;
    }

    public void setServerScheme(String serverScheme) {
        log.debug((Object)("setServerScheme(" + serverScheme + ")"));
        this.serverScheme = serverScheme;
    }

    public String getScriptName() {
        return StringUtils.isEmpty((String)this.scriptName) ? "" : this.scriptName;
    }

    public void setScriptName(String scriptName) {
        log.debug((Object)("setScriptName(" + scriptName + ")"));
        this.scriptName = scriptName;
    }

    public String getContextPath() {
        return StringUtils.isEmpty((String)this.contextPath) ? "" : this.contextPath;
    }

    public void setContextPath(String contextPath) {
        log.debug((Object)("setContextPath(" + contextPath + ")"));
        this.contextPath = contextPath;
    }

    public void getHostUrl(StringBuilder url) {
        url.append(this.getServerScheme());
        url.append("://");
        url.append(this.getServerName());
        if (this.getServerScheme().equals("http") && this.getServerPort() != 80 || this.getServerScheme().equals("https") && this.getServerPort() != 443) {
            url.append(":");
            url.append(this.getServerPort());
        }
    }

    public String toString() {
        StringBuilder url = new StringBuilder();
        this.getHostUrl(url);
        url.append(this.getContextPath());
        url.append(this.getScriptName());
        return url.toString();
    }
}

