/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.pull.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.pull.ApplicationTool;

public class DateFormatter
implements ApplicationTool {
    private static final String DATE_FORMAT_DEFAULT = "MM/dd/yyyy";
    private static final String DATE_FORMAT_KEY = "tool.dateTool.format";
    private String dateFormat = null;

    @Override
    public void init(Object data) {
        this.dateFormat = Turbine.getConfiguration().getString(DATE_FORMAT_KEY, DATE_FORMAT_DEFAULT);
    }

    @Override
    public void refresh() {
    }

    public String format(Date theDate) {
        return this.format(theDate, this.dateFormat);
    }

    public String format(Date theDate, String dateFormatString) {
        String result = null;
        SimpleDateFormat sdf = new SimpleDateFormat();
        if (StringUtils.isEmpty((String)dateFormatString) || theDate == null) {
            result = "";
        } else {
            sdf.applyPattern(dateFormatString);
            result = sdf.format(theDate);
        }
        return result;
    }
}

