/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitycheck.exception;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nullable;

public class IllegalNumberRangeException
extends RuntimeException {
    private static final long serialVersionUID = 8948110906636813037L;
    protected static final String DEFAULT_MESSAGE = "Number must be in a valid range for the given datatype.";
    protected static final String MESSAGE_WITH_VALUES = "Argument value '%s' must be in the range '%s' to '%s'.";

    private static String format(String value, BigDecimal min, BigDecimal max) {
        return String.format(MESSAGE_WITH_VALUES, value, min.toString(), max.toString());
    }

    public IllegalNumberRangeException() {
        super(DEFAULT_MESSAGE);
    }

    public IllegalNumberRangeException(String value, BigDecimal min, BigDecimal max) {
        super(IllegalNumberRangeException.format(value, min, max));
    }

    public IllegalNumberRangeException(String value, BigInteger min, BigInteger max) {
        super(IllegalNumberRangeException.format(value, new BigDecimal(min), new BigDecimal(max)));
    }

    public IllegalNumberRangeException(String value, BigInteger min, BigInteger max, @Nullable Throwable cause) {
        super(IllegalNumberRangeException.format(value, new BigDecimal(min), new BigDecimal(max)), cause);
    }

    public IllegalNumberRangeException(String value, BigDecimal min, BigDecimal max, @Nullable Throwable cause) {
        super(IllegalNumberRangeException.format(value, min, max), cause);
    }

    public IllegalNumberRangeException(@Nullable Throwable cause) {
        super(DEFAULT_MESSAGE, cause);
    }
}

