/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.util;

public class ToStringBuilder {
    private StringBuffer buffer = new StringBuffer();
    private int mode;
    private int attributeCount;
    private static int defaultMode = 3;
    public static final int INCLUDE_PACKAGE_PREFIX = 1;
    public static final int INCLUDE_HASHCODE = 2;

    public ToStringBuilder(Object target) {
        this(target, defaultMode);
    }

    public ToStringBuilder(Object target, int mode) {
        this.mode = mode;
        this.appendClassName(target);
        this.appendHashCode(target);
    }

    private void appendHashCode(Object target) {
        if ((this.mode & 2) == 0) {
            return;
        }
        this.buffer.append('@');
        this.buffer.append(Integer.toHexString(target.hashCode()));
    }

    private void appendClassName(Object target) {
        String className = target.getClass().getName();
        if ((this.mode & 1) != 0) {
            this.buffer.append(className);
            return;
        }
        int lastdotx = className.lastIndexOf(46);
        this.buffer.append(className.substring(lastdotx + 1));
    }

    public static int getDefaultMode() {
        return defaultMode;
    }

    public static void setDefaultMode(int i) {
        defaultMode = i;
    }

    public String toString() {
        if (this.attributeCount > 0) {
            this.buffer.append(']');
        }
        String result = this.buffer.toString();
        this.buffer = null;
        return result;
    }

    public void append(String attributeName, boolean value) {
        this.append(attributeName, String.valueOf(value));
    }

    public void append(String attributeName, byte value) {
        this.append(attributeName, String.valueOf(value));
    }

    public void append(String attributeName, short value) {
        this.append(attributeName, String.valueOf(value));
    }

    public void append(String attributeName, int value) {
        this.append(attributeName, String.valueOf(value));
    }

    public void append(String attributeName, Object value) {
        this.append(attributeName, String.valueOf(value));
    }

    public void append(String attributeName, String value) {
        if (this.attributeCount++ == 0) {
            this.buffer.append('[');
        } else {
            this.buffer.append(' ');
        }
        this.buffer.append(attributeName);
        this.buffer.append('=');
        this.buffer.append(value);
    }
}

