/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.template;

import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.model.turbine.TurbineAccessControlList;
import org.apache.fulcrum.security.model.turbine.TurbineUserManager;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.RunData;

public class TemplateSecurityCheck {
    private String message = "Sorry, you do not have permission to access this area.";
    private String failScreen = TurbineTemplate.getDefaultScreen();
    private String failTemplate;
    private RunData data = null;

    public TemplateSecurityCheck(RunData data, String message) {
        this.data = data;
        this.message = message;
    }

    public TemplateSecurityCheck(RunData data) {
        this.data = data;
    }

    public boolean hasRole(Role role) throws Exception {
        if (!this.checkLogin()) {
            return false;
        }
        TurbineAccessControlList acl = (TurbineAccessControlList)this.data.getACL();
        if (acl == null || !acl.hasRole(role)) {
            this.data.setScreen(this.getFailScreen());
            this.data.getTemplateInfo().setScreenTemplate(this.getFailTemplate());
            this.data.setMessage(this.getMessage());
            return false;
        }
        return true;
    }

    public boolean hasPermission(Permission permission) throws Exception {
        boolean value = true;
        TurbineAccessControlList acl = (TurbineAccessControlList)this.data.getACL();
        if (acl == null || !acl.hasPermission(permission)) {
            this.data.setScreen(this.getFailScreen());
            this.data.getTemplateInfo().setScreenTemplate(this.getFailTemplate());
            this.data.setMessage(this.getMessage());
            value = false;
        }
        return value;
    }

    public boolean checkLogin() throws Exception {
        boolean value = true;
        TurbineUserManager userManager = (TurbineUserManager)TurbineServices.getInstance().getService(TurbineUserManager.ROLE);
        if (!userManager.isAnonymousUser(this.data.getUser()) && !this.data.getUser().hasLoggedIn()) {
            this.data.setMessage(Turbine.getConfiguration().getString("login.message"));
            this.data.getTemplateInfo().setScreenTemplate(this.getFailTemplate());
            value = false;
        }
        return value;
    }

    public void setMessage(String v) {
        this.message = v;
    }

    public String getMessage() {
        return this.message;
    }

    public String getFailScreen() {
        return this.failScreen;
    }

    public void setFailScreen(String v) {
        this.failScreen = v;
    }

    public String getFailTemplate() {
        return this.failTemplate;
    }

    public void setFailTemplate(String v) {
        this.failTemplate = v;
    }
}

