/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.screens;

import java.io.OutputStream;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.turbine.annotation.TurbineConfiguration;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.modules.screens.TemplateScreen;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.template.TemplateService;
import org.apache.turbine.services.velocity.VelocityService;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class VelocityScreen
extends TemplateScreen {
    private final String prefix = this.getPrefix() + "/";
    @TurbineService
    protected VelocityService velocity;
    @TurbineService
    protected TemplateService templateService;
    @TurbineConfiguration
    protected Configuration conf;

    protected void doBuildTemplate(PipelineData pipelineData, Context context) throws Exception {
    }

    @Override
    protected void doBuildTemplate(PipelineData pipelineData) throws Exception {
        this.doBuildTemplate(pipelineData, this.velocity.getContext(pipelineData));
    }

    @Override
    public String buildTemplate(PipelineData pipelineData) throws Exception {
        RunData data = this.getRunData(pipelineData);
        String screenData = null;
        Context context = this.velocity.getContext(pipelineData);
        String screenTemplate = data.getTemplateInfo().getScreenTemplate();
        String templateName = this.templateService.getScreenTemplateName(screenTemplate);
        if (StringUtils.isEmpty((String)templateName)) {
            this.log.error((Object)("Screen " + screenTemplate + " not found!"));
            throw new Exception("Could not find screen for " + screenTemplate);
        }
        try {
            if (this.getLayout(pipelineData) == null) {
                this.velocity.handleRequest(context, this.prefix + templateName, (OutputStream)data.getResponse().getOutputStream());
            } else {
                screenData = this.velocity.handleRequest(context, this.prefix + templateName);
            }
        }
        catch (Exception e) {
            context.put("processingException", (Object)e.toString());
            context.put("stackTrace", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            templateName = this.conf.getString("template.error", "error.vm");
            screenData = this.velocity.handleRequest(context, this.prefix + templateName);
        }
        return screenData;
    }
}

