/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ListenerManager;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.UnableToInterruptJobException;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.JobFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteMBeanScheduler
implements Scheduler {
    private ObjectName schedulerObjectName;

    protected ObjectName getSchedulerObjectName() {
        return this.schedulerObjectName;
    }

    public void setSchedulerObjectName(String schedulerObjectName) throws SchedulerException {
        try {
            this.schedulerObjectName = new ObjectName(schedulerObjectName);
        }
        catch (MalformedObjectNameException e) {
            throw new SchedulerException("Failed to parse Scheduler MBean name: " + schedulerObjectName, e);
        }
    }

    public void setSchedulerObjectName(ObjectName schedulerObjectName) throws SchedulerException {
        this.schedulerObjectName = schedulerObjectName;
    }

    public abstract void initialize() throws SchedulerException;

    protected abstract Object getAttribute(String var1) throws SchedulerException;

    protected abstract AttributeList getAttributes(String[] var1) throws SchedulerException;

    protected abstract Object invoke(String var1, Object[] var2, String[] var3) throws SchedulerException;

    @Override
    public String getSchedulerName() throws SchedulerException {
        return (String)this.getAttribute("schedulerName");
    }

    @Override
    public String getSchedulerInstanceId() throws SchedulerException {
        return (String)this.getAttribute("schedulerInstanceId");
    }

    @Override
    public SchedulerMetaData getMetaData() throws SchedulerException {
        AttributeList attributeList = this.getAttributes(new String[]{"schedulerName", "schedulerInstanceId", "inStandbyMode", "shutdown", "jobStoreClass", "threadPoolClass", "threadPoolSize", "version"});
        return new SchedulerMetaData((String)attributeList.get(0), (String)attributeList.get(1), this.getClass(), true, this.isStarted(), (Boolean)attributeList.get(2), (Boolean)attributeList.get(3), (Date)this.invoke("runningSince", new Object[0], new String[0]), (Integer)this.invoke("numJobsExecuted", new Object[0], new String[0]), (Class)attributeList.get(4), (Boolean)this.invoke("supportsPersistence", new Object[0], new String[0]), (Boolean)this.invoke("isClustered", new Object[0], new String[0]), (Class)attributeList.get(5), (Integer)attributeList.get(6), (String)attributeList.get(7));
    }

    @Override
    public SchedulerContext getContext() throws SchedulerException {
        return (SchedulerContext)this.getAttribute("schedulerContext");
    }

    @Override
    public void start() throws SchedulerException {
        this.invoke("start", new Object[0], new String[0]);
    }

    @Override
    public void startDelayed(int seconds) throws SchedulerException {
        this.invoke("startDelayed", new Object[]{seconds}, new String[]{Integer.TYPE.getName()});
    }

    @Override
    public void standby() throws SchedulerException {
        this.invoke("standby", new Object[0], new String[0]);
    }

    @Override
    public boolean isStarted() throws SchedulerException {
        return this.invoke("runningSince", new Object[0], new String[0]) != null;
    }

    @Override
    public boolean isInStandbyMode() throws SchedulerException {
        return (Boolean)this.getAttribute("inStandbyMode");
    }

    @Override
    public void shutdown() throws SchedulerException {
        String schedulerName = this.getSchedulerName();
        this.invoke("shutdown", new Object[0], new String[0]);
        SchedulerRepository.getInstance().remove(schedulerName);
    }

    @Override
    public void shutdown(boolean waitForJobsToComplete) throws SchedulerException {
        String schedulerName = this.getSchedulerName();
        this.invoke("shutdown", new Object[]{this.toBoolean(waitForJobsToComplete)}, new String[]{Boolean.TYPE.getName()});
        SchedulerRepository.getInstance().remove(schedulerName);
    }

    @Override
    public boolean isShutdown() throws SchedulerException {
        return (Boolean)this.getAttribute("shutdown");
    }

    @Override
    public List<JobExecutionContext> getCurrentlyExecutingJobs() throws SchedulerException {
        return (List)this.invoke("getCurrentlyExecutingJobs", new Object[0], new String[0]);
    }

    @Override
    public Date scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        return (Date)this.invoke("scheduleJob", new Object[]{jobDetail, trigger}, new String[]{JobDetail.class.getName(), Trigger.class.getName()});
    }

    @Override
    public Date scheduleJob(Trigger trigger) throws SchedulerException {
        return (Date)this.invoke("scheduleJob", new Object[]{trigger}, new String[]{Trigger.class.getName()});
    }

    @Override
    public void addJob(JobDetail jobDetail, boolean replace) throws SchedulerException {
        this.invoke("addJob", new Object[]{jobDetail, this.toBoolean(replace)}, new String[]{JobDetail.class.getName(), Boolean.TYPE.getName()});
    }

    @Override
    public boolean deleteJob(JobKey jobKey) throws SchedulerException {
        return (Boolean)this.invoke("deleteJob", new Object[]{jobKey}, new String[]{JobKey.class.getName()});
    }

    @Override
    public boolean unscheduleJob(TriggerKey triggerKey) throws SchedulerException {
        return (Boolean)this.invoke("unscheduleJob", new Object[]{triggerKey}, new String[]{TriggerKey.class.getName()});
    }

    @Override
    public boolean deleteJobs(List<JobKey> jobKeys) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public void scheduleJobs(Map<JobDetail, List<Trigger>> triggersAndJobs, boolean replace) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public boolean unscheduleJobs(List<TriggerKey> triggerKeys) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public Date rescheduleJob(TriggerKey triggerKey, Trigger newTrigger) throws SchedulerException {
        return (Date)this.invoke("unscheduleJob", new Object[]{triggerKey, newTrigger}, new String[]{TriggerKey.class.getName(), Trigger.class.getName()});
    }

    @Override
    public void triggerJob(JobKey jobKey) throws SchedulerException {
        this.triggerJob(jobKey, null);
    }

    @Override
    public void triggerJob(JobKey jobKey, JobDataMap data) throws SchedulerException {
        this.invoke("triggerJob", new Object[]{jobKey, data}, new String[]{JobKey.class.getName(), JobDataMap.class.getName()});
    }

    @Override
    public void pauseTrigger(TriggerKey triggerKey) throws SchedulerException {
        this.invoke("pauseTrigger", new Object[]{triggerKey}, new String[]{TriggerKey.class.getName()});
    }

    @Override
    public void pauseTriggers(GroupMatcher<TriggerKey> matcher) throws SchedulerException {
        this.invoke("pauseTriggers", new Object[]{matcher}, new String[]{GroupMatcher.class.getName()});
    }

    @Override
    public void pauseJob(JobKey jobKey) throws SchedulerException {
        this.invoke("pauseJob", new Object[]{jobKey}, new String[]{JobKey.class.getName()});
    }

    @Override
    public void pauseJobs(GroupMatcher<JobKey> matcher) throws SchedulerException {
        this.invoke("pauseJobs", new Object[]{matcher}, new String[]{GroupMatcher.class.getName()});
    }

    @Override
    public void resumeTrigger(TriggerKey triggerKey) throws SchedulerException {
        this.invoke("resumeTrigger", new Object[]{triggerKey}, new String[]{TriggerKey.class.getName()});
    }

    @Override
    public void resumeTriggers(GroupMatcher<TriggerKey> matcher) throws SchedulerException {
        this.invoke("resumeTriggers", new Object[]{matcher}, new String[]{GroupMatcher.class.getName()});
    }

    @Override
    public void resumeJob(JobKey jobKey) throws SchedulerException {
        this.invoke("resumeJob", new Object[]{jobKey}, new String[]{JobKey.class.getName()});
    }

    @Override
    public void resumeJobs(GroupMatcher<JobKey> matcher) throws SchedulerException {
        this.invoke("resumeJobs", new Object[]{matcher}, new String[]{GroupMatcher.class.getName()});
    }

    @Override
    public void pauseAll() throws SchedulerException {
        this.invoke("pauseAll", new Object[0], new String[0]);
    }

    @Override
    public void resumeAll() throws SchedulerException {
        this.invoke("resumeAll", new Object[0], new String[0]);
    }

    @Override
    public List<String> getJobGroupNames() throws SchedulerException {
        return (List)this.invoke("getJobGroupNames", new Object[0], new String[0]);
    }

    @Override
    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> matcher) throws SchedulerException {
        Set keys = (Set)this.invoke("getJobNames", new Object[]{matcher}, new String[]{GroupMatcher.class.getName()});
        return keys;
    }

    public List<Trigger> getTriggersOfJob(JobKey jobKey) throws SchedulerException {
        return (List)this.invoke("getTriggersOfJob", new Object[]{jobKey}, new String[]{JobKey.class.getName()});
    }

    @Override
    public List<String> getTriggerGroupNames() throws SchedulerException {
        return (List)this.invoke("getTriggerGroupNames", new Object[0], new String[0]);
    }

    @Override
    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> matcher) throws SchedulerException {
        Set keys = (Set)this.invoke("getTriggerKeys", new Object[]{matcher}, new String[]{GroupMatcher.class.getName()});
        return keys;
    }

    @Override
    public JobDetail getJobDetail(JobKey jobKey) throws SchedulerException {
        return (JobDetail)this.invoke("getJobDetail", new Object[]{jobKey}, new String[]{JobKey.class.getName()});
    }

    @Override
    public Trigger getTrigger(TriggerKey triggerKey) throws SchedulerException {
        return (Trigger)this.invoke("getTrigger", new Object[]{triggerKey}, new String[]{TriggerKey.class.getName()});
    }

    @Override
    public boolean checkExists(JobKey jobKey) throws SchedulerException {
        return (Boolean)this.invoke("checkExists", new Object[]{jobKey}, new String[]{JobKey.class.getName()});
    }

    @Override
    public boolean checkExists(TriggerKey triggerKey) throws SchedulerException {
        return (Boolean)this.invoke("checkExists", new Object[]{triggerKey}, new String[]{TriggerKey.class.getName()});
    }

    @Override
    public void clear() throws SchedulerException {
        this.invoke("clear", new Object[0], new String[0]);
    }

    @Override
    public Trigger.TriggerState getTriggerState(TriggerKey triggerKey) throws SchedulerException {
        return (Trigger.TriggerState)((Object)this.invoke("getTriggerState", new Object[]{triggerKey}, new String[]{TriggerKey.class.getName()}));
    }

    @Override
    public void addCalendar(String calName, Calendar calendar, boolean replace, boolean updateTriggers) throws SchedulerException {
        this.invoke("addCalendar", new Object[]{calName, calendar, this.toBoolean(replace), this.toBoolean(updateTriggers)}, new String[]{String.class.getName(), Calendar.class.getName(), Boolean.TYPE.getName(), Boolean.TYPE.getName()});
    }

    @Override
    public boolean deleteCalendar(String calName) throws SchedulerException {
        return (Boolean)this.invoke("getTriggerState", new Object[]{calName}, new String[]{String.class.getName()});
    }

    @Override
    public Calendar getCalendar(String calName) throws SchedulerException {
        return (Calendar)this.invoke("getCalendar", new Object[]{calName}, new String[]{String.class.getName()});
    }

    @Override
    public List<String> getCalendarNames() throws SchedulerException {
        return (List)this.invoke("getCalendarNames", new Object[0], new String[0]);
    }

    @Override
    public Set<String> getPausedTriggerGroups() throws SchedulerException {
        return (Set)this.invoke("getPausedTriggerGroups", new Object[0], new String[0]);
    }

    @Override
    public ListenerManager getListenerManager() throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    @Override
    public boolean interrupt(JobKey jobKey) throws UnableToInterruptJobException {
        try {
            return (Boolean)this.invoke("interrupt", new Object[]{jobKey}, new String[]{JobKey.class.getName()});
        }
        catch (SchedulerException se) {
            throw new UnableToInterruptJobException(se);
        }
    }

    @Override
    public void setJobFactory(JobFactory factory) throws SchedulerException {
        throw new SchedulerException("Operation not supported for remote schedulers.");
    }

    protected Boolean toBoolean(boolean bool) {
        return bool ? Boolean.TRUE : Boolean.FALSE;
    }
}

