/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.assemblerbroker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.annotation.AnnotationProcessor;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.modules.Loader;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.services.assemblerbroker.util.AssemblerFactory;
import org.apache.turbine.util.TurbineException;

public class TurbineAssemblerBrokerService
extends TurbineBaseService
implements AssemblerBrokerService {
    private static Log log = LogFactory.getLog(TurbineAssemblerBrokerService.class);
    private Map<Class<?>, List<?>> factories = null;
    private Map<String, Assembler> assemblerCache = null;
    private Map<Class<?>, Loader<? extends Assembler>> loaderCache = null;
    private boolean isCaching;

    private <T extends Assembler> List<AssemblerFactory<T>> getFactoryGroup(Class<T> type) {
        if (!this.factories.containsKey(type)) {
            this.factories.put(type, new ArrayList());
        }
        return this.factories.get(type);
    }

    private void registerFactories(String type) throws TurbineException {
        List names = this.getConfiguration().getList(type);
        log.info((Object)("Registering " + names.size() + " " + type + " factories."));
        for (String factory : names) {
            try {
                AssemblerFactory af = (AssemblerFactory)Class.forName(factory).newInstance();
                this.registerFactory(af);
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (Throwable t) {
                throw new TurbineException("Failed registering " + type + " factory: " + factory, t);
            }
        }
    }

    @Override
    public void init() throws InitializationException {
        this.factories = new HashMap();
        try {
            Configuration conf = this.getConfiguration();
            Iterator i = conf.getKeys();
            while (i.hasNext()) {
                String type = (String)i.next();
                if ("classname".equalsIgnoreCase(type)) continue;
                this.registerFactories(type);
            }
        }
        catch (TurbineException e) {
            throw new InitializationException("AssemblerBrokerService failed to initialize", e);
        }
        this.isCaching = Turbine.getConfiguration().getBoolean("module.cache", true);
        if (this.isCaching) {
            int cacheSize = Turbine.getConfiguration().getInt("module.cache.size", 128);
            this.assemblerCache = new LRUMap(cacheSize);
            this.loaderCache = new LRUMap(cacheSize);
        }
        this.setInit(true);
    }

    @Override
    public <T extends Assembler> void registerFactory(AssemblerFactory<T> factory) {
        this.getFactoryGroup(factory.getManagedClass()).add(factory);
    }

    @Override
    public <T extends Assembler> T getAssembler(Class<T> type, String name) throws TurbineException {
        String key = type + ":" + name;
        Assembler assembler = null;
        if (this.isCaching && this.assemblerCache.containsKey(key)) {
            assembler = this.assemblerCache.get(key);
            log.debug((Object)("Found " + key + " in the cache!"));
        } else {
            log.debug((Object)("Loading " + key));
            List<AssemblerFactory<T>> facs = this.getFactoryGroup(type);
            Iterator<AssemblerFactory<T>> it = facs.iterator();
            while (assembler == null && it.hasNext()) {
                AssemblerFactory<T> fac = it.next();
                try {
                    assembler = fac.getAssembler(name);
                }
                catch (Exception e) {
                    throw new TurbineException("Failed to load an assembler for " + name + " from the " + type + " factory " + fac.getClass().getName(), e);
                }
                if (assembler == null) continue;
                AnnotationProcessor.process(assembler);
                if (!this.isCaching) continue;
                this.assemblerCache.put(key, assembler);
            }
        }
        return (T)assembler;
    }

    @Override
    public <T extends Assembler> Loader<T> getLoader(Class<T> type) {
        Loader<Assembler> loader = null;
        if (this.isCaching && this.loaderCache.containsKey(type)) {
            loader = this.loaderCache.get(type);
            log.debug((Object)("Found " + type + " loader in the cache!"));
        } else {
            log.debug((Object)("Getting Loader for " + type));
            List<AssemblerFactory<T>> facs = this.getFactoryGroup(type);
            Iterator<AssemblerFactory<T>> it = facs.iterator();
            while (loader == null && it.hasNext()) {
                AssemblerFactory<T> fac = it.next();
                loader = fac.getLoader();
            }
            if (this.isCaching && loader != null) {
                this.loaderCache.put(type, loader);
            }
        }
        if (loader == null) {
            log.warn((Object)("Loader for " + type + " is null."));
        }
        return loader;
    }
}

