/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.screens;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.turbine.modules.screens.VelocityScreen;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class VelocityCachedScreen
extends VelocityScreen {
    private String prefix = this.getPrefix() + "/";

    @Override
    public String buildTemplate(PipelineData pipelineData) throws Exception {
        RunData data = this.getRunData(pipelineData);
        Context context = this.velocity.getContext(pipelineData);
        String screenTemplate = data.getTemplateInfo().getScreenTemplate();
        String templateName = this.templateService.getScreenTemplateName(screenTemplate);
        if (StringUtils.isEmpty((String)templateName)) {
            this.log.error((Object)("Screen " + screenTemplate + " not found!"));
            throw new Exception("Could not find screen for " + screenTemplate);
        }
        try {
            this.velocity.handleRequest(context, this.prefix + templateName, data.getOut());
        }
        catch (Exception e) {
            context.put("processingException", (Object)e.toString());
            context.put("stackTrace", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            templateName = this.conf.getString("template.error", "error.vm");
            this.velocity.handleRequest(context, this.prefix + templateName, data.getOut());
        }
        return null;
    }
}

