/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.fulcrum.security.entity.SecurityEntity;

public abstract class SecuritySet<T extends SecurityEntity>
implements Serializable,
Set<T>,
Iterable<T> {
    private static final long serialVersionUID = 2251987059226422569L;
    protected Map<String, T> nameMap = new TreeMap<String, T>();
    protected Map<Object, T> idMap = new TreeMap<Object, T>();

    public Set<T> getSet() {
        return new HashSet<T>(this.idMap.values());
    }

    public Set<String> getNames() {
        return this.nameMap.keySet();
    }

    public Set<Object> getIds() {
        return this.idMap.keySet();
    }

    @Override
    public void clear() {
        this.nameMap.clear();
        this.idMap.clear();
    }

    public boolean containsName(String name) {
        return StringUtils.isNotEmpty((String)name) ? this.nameMap.containsKey(name.toLowerCase()) : false;
    }

    public boolean containsId(Object id) {
        return id == null ? false : this.idMap.containsKey(id);
    }

    @Override
    public Iterator<T> iterator() {
        return this.idMap.values().iterator();
    }

    @Override
    public int size() {
        return this.idMap.size();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(12 * this.size());
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            SecurityEntity se = (SecurityEntity)it.next();
            sbuf.append('[');
            sbuf.append(se.getName());
            sbuf.append(" -> ");
            sbuf.append(se.getId());
            sbuf.append(']');
            if (!it.hasNext()) continue;
            sbuf.append(", ");
        }
        return sbuf.toString();
    }

    @Override
    public boolean add(T o) {
        if (this.contains(o)) {
            return false;
        }
        if (o.getId() != null) {
            this.idMap.put(o.getId(), o);
        }
        if (o.getName() != null) {
            this.nameMap.put(o.getName(), o);
        }
        return true;
    }

    @Override
    public boolean add(Collection<? extends T> collection) {
        return this.addAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean res = false;
        for (SecurityEntity o : collection) {
            res |= this.add((T)o);
        }
        return res;
    }

    @Override
    public boolean isEmpty() {
        return this.idMap.isEmpty();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object object : collection) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        for (Object object : collection) {
            boolean result = this.remove(object);
            if (!result) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Object[] toArray() {
        return this.getSet().toArray();
    }

    @Override
    public boolean contains(Object o) {
        if (o == null || !(o instanceof SecurityEntity)) {
            return false;
        }
        return this.containsId(((SecurityEntity)o).getId());
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof SecurityEntity) {
            boolean res = this.contains(o);
            this.idMap.remove(((SecurityEntity)o).getId());
            this.nameMap.remove(((SecurityEntity)o).getName());
            return res;
        }
        return false;
    }

    @Override
    public <A> A[] toArray(A[] a) {
        return this.getSet().toArray(a);
    }

    public T getByName(String name) {
        return (T)((SecurityEntity)this.nameMap.get(name.toLowerCase()));
    }

    public T getById(Object id) {
        return (T)((SecurityEntity)this.idMap.get(id));
    }
}

