/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.util;

import java.util.ArrayList;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;

public class AvalonTee
implements LogEnabled,
Contextualizable,
Configurable,
Startable,
Disposable {
    private ArrayList m_listeners = new ArrayList(10);
    private int m_len = 0;
    private boolean m_readOnly = false;

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    public void addTee(Object obj) {
        if (this.m_readOnly) {
            throw new IllegalStateException("makeReadOnly() already invoked");
        }
        if (obj == null) {
            throw new NullPointerException("obj");
        }
        if (!this.m_listeners.contains(obj)) {
            this.m_listeners.add(obj);
            this.m_len = this.m_listeners.size();
        }
    }

    public void enableLogging(Logger logger) {
        for (int i = 0; i < this.m_len; ++i) {
            ContainerUtil.enableLogging(this.m_listeners.get(i), (Logger)logger);
        }
    }

    public void contextualize(Context context) throws ContextException {
        for (int i = 0; i < this.m_len; ++i) {
            ContainerUtil.contextualize(this.m_listeners.get(i), (Context)context);
        }
    }

    public void configure(Configuration config) throws ConfigurationException {
        for (int i = 0; i < this.m_len; ++i) {
            ContainerUtil.configure(this.m_listeners.get(i), (Configuration)config);
        }
    }

    public void start() throws Exception {
        for (int i = 0; i < this.m_len; ++i) {
            ContainerUtil.start(this.m_listeners.get(i));
        }
    }

    public void stop() throws Exception {
        for (int i = 0; i < this.m_len; ++i) {
            ContainerUtil.stop(this.m_listeners.get(i));
        }
    }

    public void dispose() {
        for (int i = 0; i < this.m_len; ++i) {
            ContainerUtil.dispose(this.m_listeners.get(i));
        }
    }
}

