/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.template;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ecs.ConcreteElement;
import org.apache.turbine.modules.NavigationLoader;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.RunData;

public class TemplateNavigation {
    private static Log log = LogFactory.getLog(TemplateNavigation.class);
    private RunData data;
    private String template = null;

    public TemplateNavigation(RunData data) {
        this.data = data;
    }

    public TemplateNavigation setTemplate(String template) {
        log.debug((Object)("setTemplate(" + template + ")"));
        this.template = template;
        return this;
    }

    public String toString() {
        String module = null;
        String returnValue = null;
        try {
            if (this.template == null) {
                returnValue = "Navigation Template is null (Might be unset)";
                throw new Exception(returnValue);
            }
            this.data.getTemplateInfo().setNavigationTemplate(this.template);
            module = TurbineTemplate.getNavigationName(this.template);
            if (module == null) {
                returnValue = "Template Service returned null for Navigation Template " + this.template;
                throw new Exception(returnValue);
            }
            ConcreteElement results = NavigationLoader.getInstance().eval(this.data, module);
            returnValue = results.toString();
        }
        catch (Exception e) {
            if (returnValue == null) {
                returnValue = "Error processing navigation template: " + this.template + ", using module: " + module;
            }
            log.error((Object)returnValue, (Throwable)e);
        }
        return returnValue;
    }
}

