/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.torque;

import java.util.Iterator;
import org.apache.torque.om.Persistent;
import org.apache.turbine.om.security.Group;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.services.security.torque.GroupPeerManager;
import org.apache.turbine.services.security.torque.TorqueObject;
import org.apache.turbine.util.security.RoleSet;
import org.apache.turbine.util.security.TurbineSecurityException;

public class TorqueGroup
extends TorqueObject
implements Group,
Comparable {
    private static final long serialVersionUID = -2034684697021752888L;

    public TorqueGroup() {
    }

    public TorqueGroup(String name) {
        super(name);
    }

    public TorqueGroup(Persistent obj) {
        super(obj);
    }

    @Override
    public Persistent getPersistentObj() {
        if (this.obj == null) {
            this.obj = GroupPeerManager.newPersistentInstance();
        }
        return this.obj;
    }

    @Override
    public String getName() {
        return GroupPeerManager.getGroupName(this.getPersistentObj());
    }

    @Override
    public void setName(String name) {
        GroupPeerManager.setGroupName(this.getPersistentObj(), name);
    }

    @Override
    public int getId() {
        return GroupPeerManager.getIdAsObj(this.getPersistentObj());
    }

    @Override
    public Integer getIdAsObj() {
        return GroupPeerManager.getIdAsObj(this.getPersistentObj());
    }

    @Override
    public void setId(int id) {
        GroupPeerManager.setId(this.getPersistentObj(), id);
    }

    public static Group getGlobalGroup() {
        return TurbineSecurity.getGlobalGroup();
    }

    public static Group create(String name) throws TurbineSecurityException {
        return TurbineSecurity.createGroup(name);
    }

    @Override
    public void save() throws TurbineSecurityException {
        TurbineSecurity.saveGroup(this);
    }

    @Override
    public void remove() throws TurbineSecurityException {
        TurbineSecurity.removeGroup(this);
    }

    @Override
    public void rename(String name) throws TurbineSecurityException {
        TurbineSecurity.renameGroup(this, name);
    }

    @Override
    public void grant(User user, Role role) throws TurbineSecurityException {
        TurbineSecurity.grant(user, this, role);
    }

    @Override
    public void grant(User user, RoleSet roleSet) throws TurbineSecurityException {
        Iterator roles = roleSet.iterator();
        while (roles.hasNext()) {
            TurbineSecurity.grant(user, this, (Role)roles.next());
        }
    }

    @Override
    public void revoke(User user, Role role) throws TurbineSecurityException {
        TurbineSecurity.revoke(user, this, role);
    }

    @Override
    public void revoke(User user, RoleSet roleSet) throws TurbineSecurityException {
        Iterator roles = roleSet.iterator();
        while (roles.hasNext()) {
            TurbineSecurity.revoke(user, this, (Role)roles.next());
        }
    }
}

