/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;

public class ByteArrayDataSource
implements DataSource {
    public static final int BUFFER_SIZE = 512;
    private ByteArrayOutputStream baos;
    private String type = "application/octet-stream";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ByteArrayDataSource(byte[] data, String aType) throws IOException {
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(data);
            this.byteArrayDataSource(bis, aType);
            Object var6_4 = null;
            if (bis == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (bis == null) throw throwable;
            bis.close();
            throw throwable;
        }
        bis.close();
    }

    public ByteArrayDataSource(InputStream aIs, String aType) throws IOException {
        this.byteArrayDataSource(aIs, aType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ByteArrayDataSource(String data, String aType) throws IOException {
        this.type = aType;
        try {
            try {
                this.baos = new ByteArrayOutputStream();
                this.baos.write(data.getBytes("iso-8859-1"));
                this.baos.flush();
                this.baos.close();
            }
            catch (UnsupportedEncodingException uex) {
                throw new IOException("The Character Encoding is not supported.");
            }
            Object var5_3 = null;
            if (this.baos == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (this.baos == null) throw throwable;
            this.baos.close();
            throw throwable;
        }
        this.baos.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void byteArrayDataSource(InputStream aIs, String aType) throws IOException {
        FilterOutputStream osWriter;
        block11: {
            this.type = aType;
            BufferedInputStream bis = null;
            osWriter = null;
            try {
                int length = 0;
                byte[] buffer = new byte[512];
                bis = new BufferedInputStream(aIs);
                this.baos = new ByteArrayOutputStream();
                osWriter = new BufferedOutputStream(this.baos);
                while (true) {
                    if ((length = bis.read(buffer)) == -1) {
                        ((BufferedOutputStream)osWriter).flush();
                        osWriter.close();
                        break;
                    }
                    ((BufferedOutputStream)osWriter).write(buffer, 0, length);
                }
                Object var8_8 = null;
                if (bis == null) break block11;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (bis != null) {
                    bis.close();
                }
                if (this.baos != null) {
                    this.baos.close();
                }
                if (osWriter == null) throw throwable;
                osWriter.close();
                throw throwable;
            }
            bis.close();
        }
        if (this.baos != null) {
            this.baos.close();
        }
        if (osWriter == null) return;
        osWriter.close();
    }

    public String getContentType() {
        return this.type == null ? "application/octet-stream" : this.type;
    }

    public InputStream getInputStream() throws IOException {
        if (this.baos == null) {
            throw new IOException("no data");
        }
        return new ByteArrayInputStream(this.baos.toByteArray());
    }

    public String getName() {
        return "ByteArrayDataSource";
    }

    public OutputStream getOutputStream() {
        this.baos = new ByteArrayOutputStream();
        return this.baos;
    }
}

