/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JNDIConfiguration
extends AbstractConfiguration {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$configuration$JNDIConfiguration == null ? (class$org$apache$commons$configuration$JNDIConfiguration = JNDIConfiguration.class$("org.apache.commons.configuration.JNDIConfiguration")) : class$org$apache$commons$configuration$JNDIConfiguration));
    private String prefix;
    private Context context;
    private Context baseContext;
    private Set clearedProperties = new HashSet();
    static /* synthetic */ Class class$org$apache$commons$configuration$JNDIConfiguration;

    public JNDIConfiguration() throws NamingException {
        this((String)null);
    }

    public JNDIConfiguration(String prefix) throws NamingException {
        this(new InitialContext(), prefix);
    }

    public JNDIConfiguration(Context context) {
        this(context, null);
    }

    public JNDIConfiguration(Context context, String prefix) {
        this.context = context;
        this.prefix = prefix;
    }

    public void addProperty(String key, Object token) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recursiveGetKeys(Set keys, Context context, String prefix) throws NamingException {
        NamingEnumeration<NameClassPair> elements = null;
        try {
            elements = context.list("");
            while (elements.hasMore()) {
                NameClassPair nameClassPair = elements.next();
                String name = nameClassPair.getName();
                Object object = context.lookup(name);
                StringBuffer key = new StringBuffer();
                key.append(prefix);
                if (key.length() > 0) {
                    key.append(".");
                }
                key.append(name);
                if (object instanceof Context) {
                    Context subcontext = (Context)object;
                    this.recursiveGetKeys(keys, subcontext, key.toString());
                    continue;
                }
                keys.add(key.toString());
            }
        }
        finally {
            if (elements != null) {
                elements.close();
            }
        }
    }

    public Iterator getKeys() {
        return this.getKeys("");
    }

    public Iterator getKeys(String prefix) {
        String[] splitPath = StringUtils.split((String)prefix, (String)".");
        ArrayList<String> path = new ArrayList<String>();
        for (int i = 0; i < splitPath.length; ++i) {
            path.add(splitPath[i]);
        }
        try {
            Context context = this.getContext(path, this.getBaseContext());
            HashSet<String> keys = new HashSet<String>();
            if (context != null) {
                this.recursiveGetKeys(keys, context, prefix);
            } else if (this.containsKey(prefix)) {
                keys.add(prefix);
            }
            return keys.iterator();
        }
        catch (NamingException e) {
            throw new ConfigurationRuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context getContext(List path, Context context) throws NamingException {
        if (path == null || path.isEmpty()) {
            return context;
        }
        String key = (String)path.get(0);
        NamingEnumeration<NameClassPair> elements = null;
        try {
            elements = context.list("");
            while (elements.hasMore()) {
                NameClassPair nameClassPair = elements.next();
                String name = nameClassPair.getName();
                Object object = context.lookup(name);
                if (!(object instanceof Context) || !name.equals(key)) continue;
                Context subcontext = (Context)object;
                Context context2 = this.getContext(path.subList(1, path.size()), subcontext);
                return context2;
            }
        }
        finally {
            if (elements != null) {
                elements.close();
            }
        }
        return null;
    }

    public Properties getProperties(String key) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        boolean bl;
        block6: {
            NamingEnumeration<NameClassPair> enumeration = null;
            try {
                enumeration = this.getBaseContext().list("");
                boolean bl2 = bl = !enumeration.hasMore();
                if (enumeration == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (enumeration != null) {
                        enumeration.close();
                    }
                    throw throwable;
                }
                catch (NamingException ne) {
                    log.warn((Object)ne);
                    return true;
                }
            }
            enumeration.close();
        }
        return bl;
    }

    public Object getProperty(String key) {
        return this.getPropertyDirect(key);
    }

    public void setProperty(String key, Object value) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public void clearProperty(String key) {
        this.clearedProperties.add(key);
    }

    public boolean containsKey(String key) {
        if (this.clearedProperties.contains(key)) {
            return false;
        }
        key = StringUtils.replace((String)key, (String)".", (String)"/");
        try {
            this.getBaseContext().lookup(key);
            return true;
        }
        catch (NamingException ne) {
            return false;
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.baseContext = null;
    }

    protected Object getPropertyDirect(String key) {
        if (this.clearedProperties.contains(key)) {
            return null;
        }
        try {
            key = StringUtils.replace((String)key, (String)".", (String)"/");
            return this.getBaseContext().lookup(key);
        }
        catch (NameNotFoundException e) {
            return null;
        }
        catch (NotContextException e) {
            return null;
        }
        catch (NamingException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void addPropertyDirect(String key, Object obj) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public Context getBaseContext() throws NamingException {
        if (this.baseContext == null) {
            this.baseContext = (Context)this.getContext().lookup(this.prefix == null ? "" : this.prefix);
        }
        return this.baseContext;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.clearedProperties.clear();
        this.context = context;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

