/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.parser;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.fulcrum.parser.BaseValueParser;
import org.apache.fulcrum.parser.CookieParser;

public class DefaultCookieParser
extends BaseValueParser
implements CookieParser {
    private HttpServletRequest request;
    private HttpServletResponse response;

    @Override
    public void dispose() {
        this.request = null;
        this.response = null;
        super.dispose();
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public void setData(HttpServletRequest request, HttpServletResponse response) {
        this.clear();
        String enc = request.getCharacterEncoding();
        this.setCharacterEncoding(enc != null ? enc : "US-ASCII");
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            this.getLogger().debug("Number of Cookies " + cookies.length);
            for (Cookie cookie : cookies) {
                String name = this.convert(cookie.getName());
                String value = cookie.getValue();
                this.getLogger().debug("Adding " + name + "=" + value);
                this.add(name, value);
            }
        }
        this.request = request;
        this.response = response;
    }

    @Override
    public void set(String name, String value) {
        this.set(name, value, -1);
    }

    @Override
    public void set(String name, String value, int secondsAge) {
        if (this.response == null) {
            throw new IllegalStateException("Servlet response not available");
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(secondsAge);
        cookie.setPath(this.request.getServletPath());
        this.response.addCookie(cookie);
    }

    @Override
    public void unset(String name) {
        this.set(name, " ", 0);
    }

    @Override
    public boolean isValid() {
        return this.parameters.size() == 0;
    }
}

