/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.audit;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import org.apache.openjpa.audit.Auditor;
import org.apache.openjpa.kernel.Audited;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.lib.conf.Configuration;

public class AuditLogger
implements Auditor {
    private PrintStream _out = System.out;
    private String _file;

    @Override
    public void audit(Broker broker, Collection<Audited> newObjects, Collection<Audited> updates, Collection<Audited> deletes) {
        for (Audited audited : newObjects) {
            this._out.print(String.valueOf((Object)audited.getType()) + ": [" + String.valueOf(audited.getManagedObject()) + "]");
            this._out.println(" Fields:" + Arrays.toString(audited.getUpdatedFields()));
        }
        for (Audited audited : updates) {
            this._out.print(String.valueOf((Object)audited.getType()) + ": [" + String.valueOf(audited.getOriginalObject()) + "] to [" + String.valueOf(audited.getManagedObject()) + "]");
            this._out.println(" Fields:" + Arrays.toString(audited.getUpdatedFields()));
        }
        for (Audited audited : deletes) {
            this._out.print(String.valueOf((Object)audited.getType()) + ": [" + String.valueOf(audited.getOriginalObject()) + "]");
            this._out.println(" Fields:" + Arrays.toString(audited.getUpdatedFields()));
        }
    }

    public void setFile(String file) throws FileNotFoundException {
        this._file = file;
        this._out = new PrintStream(new FileOutputStream(this._file), true);
    }

    public String getFile() {
        return this._file;
    }

    @Override
    public boolean isRollbackOnError() {
        return false;
    }

    @Override
    public void setConfiguration(Configuration conf) {
    }

    @Override
    public void startConfiguration() {
    }

    @Override
    public void endConfiguration() {
    }

    @Override
    public void close() throws Exception {
        if (this._out != System.out) {
            this._out.close();
        }
    }
}

