/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import jakarta.servlet.ServletContext;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.catalina.connector.Request;
import org.apache.openejb.AppContext;
import org.apache.openejb.cdi.CdiAppContextsService;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.tomee.catalina.OpenEJBSecurityListener;
import org.apache.tomee.catalina.TomcatWebAppBuilder;

public interface ServletContextProxy
extends ServletContext,
Serializable {
    public Object writeReplace() throws ObjectStreamException;

    public static ServletContext get() {
        return (ServletContext)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ServletContextProxy.class, ServletContext.class, CdiAppContextsService.FiredManually.class, Serializable.class}, (InvocationHandler)new Handler());
    }

    public static class Handler
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("writeReplace") && method.getParameterTypes().length == 0) {
                return new Serialized();
            }
            Request request = OpenEJBSecurityListener.requests.get();
            if (request != null) {
                return method.invoke((Object)request.getServletContext(), args);
            }
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            ServletContext c = TomcatWebAppBuilder.CONTEXTS.get(contextClassLoader);
            if (c != null) {
                return method.invoke((Object)c, args);
            }
            OpenEJBSecurityListener.requests.remove();
            for (AppContext a : ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getAppContexts()) {
                for (WebContext w : a.getWebContexts()) {
                    if (w.getClassLoader() != contextClassLoader) continue;
                    return method.invoke((Object)w.getServletContext(), args);
                }
            }
            throw new IllegalStateException("Didnt find a web context for " + String.valueOf(contextClassLoader));
        }
    }

    public static class Serialized
    implements Serializable {
        public Object readResolve() throws ObjectStreamException {
            return ServletContextProxy.get();
        }
    }
}

