/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.JPAQuery;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class NamedNativeQueryMetadata
extends NamedQueryMetadata {
    private MetadataClass m_resultClass;
    private String m_resultClassName;
    private String m_resultSetMapping;

    public NamedNativeQueryMetadata() {
        super("<named-native-query>");
    }

    public NamedNativeQueryMetadata(MetadataAnnotation namedNativeQuery, MetadataAccessor accessor) {
        super(namedNativeQuery, accessor);
        this.m_resultClass = this.getMetadataClass(namedNativeQuery.getAttributeString("resultClass"));
        this.m_resultSetMapping = namedNativeQuery.getAttributeString("resultSetMapping");
    }

    protected NamedNativeQueryMetadata(String javaClassName) {
        super(javaClassName);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof NamedNativeQueryMetadata) {
            NamedNativeQueryMetadata query = (NamedNativeQueryMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_resultClass, query.getResultClass())) {
                return false;
            }
            return this.valuesMatch(this.m_resultSetMapping, query.getResultSetMapping());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = this.m_resultClass != null ? this.m_resultClass.hashCode() : 0;
        result = 31 * result + (this.m_resultSetMapping != null ? this.m_resultSetMapping.hashCode() : 0);
        return result;
    }

    public MetadataClass getResultClass() {
        return this.m_resultClass;
    }

    public String getResultClassName() {
        return this.m_resultClassName;
    }

    public String getResultSetMapping() {
        return this.m_resultSetMapping;
    }

    protected boolean hasResultSetMapping(AbstractSession session) {
        if (this.m_resultSetMapping != null && !this.m_resultSetMapping.equals("")) {
            if (session.getProject().hasSQLResultSetMapping(this.m_resultSetMapping)) {
                return true;
            }
            throw ValidationException.invalidSQLResultSetMapping(this.m_resultSetMapping, this.getName(), this.getLocation());
        }
        return false;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_resultClass = this.initXMLClassName(this.m_resultClassName);
    }

    @Override
    public void process(AbstractSession session) {
        JPAQuery query = new JPAQuery(this.getName(), this.getQuery(), this.processQueryHints(session));
        if (!this.getResultClass().isVoid()) {
            query.setResultClassName(this.getJavaClassName(this.getResultClass()));
        } else if (this.hasResultSetMapping(session)) {
            query.addResultSetMapping(this.getResultSetMapping());
        }
        this.addJPAQuery(query, session);
    }

    public void setResultClass(MetadataClass resultClass) {
        this.m_resultClass = resultClass;
    }

    public void setResultClassName(String resultClassName) {
        this.m_resultClassName = resultClassName;
    }

    public void setResultSetMapping(String resultSetMapping) {
        this.m_resultSetMapping = resultSetMapping;
    }
}

