/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.swizzle.stream;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.tomitribe.swizzle.stream.DelimitedTokenReplacementInputStream;
import org.tomitribe.swizzle.stream.StringTokenHandler;

public class ResolveUrlInputStream
extends DelimitedTokenReplacementInputStream {
    public ResolveUrlInputStream(InputStream in, String begin, String end, URL url) {
        super(in, begin, end, new UrlResolver(begin, end, url), false);
    }

    public static class UrlResolver
    extends StringTokenHandler {
        private final URL parent;
        private final String begin;
        private final String end;

        public UrlResolver(String begin, String end, URL parent) {
            this.begin = begin;
            this.end = end;
            this.parent = parent;
        }

        @Override
        public String handleToken(String token) throws IOException {
            String cleanedToken = token.replaceAll("[ \"']", "");
            URL newURL = new URL(this.parent, cleanedToken);
            StringBuffer link = new StringBuffer();
            link.append(this.begin.toLowerCase());
            if (!this.begin.endsWith("\"")) {
                link.append('\"');
            }
            link.append(newURL.toExternalForm());
            if (!this.end.startsWith("\"")) {
                link.append('\"');
            }
            link.append(this.end);
            return link.toString();
        }
    }
}

