/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.spi;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.constants.JacksonConstants;
import io.smallrye.openapi.api.constants.KotlinConstants;
import io.smallrye.openapi.api.constants.SecurityConstants;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.models.OperationImpl;
import io.smallrye.openapi.api.models.media.ContentImpl;
import io.smallrye.openapi.api.models.media.MediaTypeImpl;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.models.parameters.RequestBodyImpl;
import io.smallrye.openapi.api.models.responses.APIResponseImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.BeanValidationScanner;
import io.smallrye.openapi.runtime.scanner.processor.JavaSecurityProcessor;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.scanner.spi.ScannerSPILogging;
import io.smallrye.openapi.runtime.scanner.spi.ScannerSPIMessages;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public interface AnnotationScanner {
    public String getName();

    public OpenAPI scan(AnnotationScannerContext var1, OpenAPI var2);

    public boolean isAsyncResponse(MethodInfo var1);

    public boolean isPostMethod(MethodInfo var1);

    public boolean isDeleteMethod(MethodInfo var1);

    public boolean containsScannerAnnotations(List<AnnotationInstance> var1, List<AnnotationScannerExtension> var2);

    public void setContextRoot(String var1);

    public String[] getDefaultConsumes(AnnotationScannerContext var1, MethodInfo var2, ResourceParameters var3);

    public String[] getDefaultProduces(AnnotationScannerContext var1, MethodInfo var2);

    default public boolean isMultipartOutput(Type returnType) {
        return false;
    }

    default public boolean isMultipartInput(Type inputType) {
        return false;
    }

    default public boolean isScannerInternalResponse(Type returnType) {
        return false;
    }

    default public boolean isScannerInternalParameter(Type parameterType) {
        return false;
    }

    default public boolean isWrapperType(Type type) {
        return false;
    }

    default public Type unwrapType(Type type) {
        if (this.isWrapperType(type)) {
            return (Type)type.asParameterizedType().arguments().get(0);
        }
        return null;
    }

    default public OpenAPI processDefinitionAnnotation(AnnotationScannerContext context, ClassInfo targetClass) {
        return Optional.ofNullable((OpenAPI)context.io().read((AnnotationTarget)targetClass)).orElseGet(() -> new OpenAPIImpl().openapi("3.0.3"));
    }

    default public void processSecuritySchemeAnnotation(AnnotationScannerContext context, ClassInfo targetClass, OpenAPI openApi) {
        context.io().security().readSchemes((AnnotationTarget)targetClass).forEach((name, scheme) -> ModelUtil.components(openApi).addSecurityScheme(name, scheme));
    }

    default public void processServerAnnotation(AnnotationScannerContext context, ClassInfo targetClass, OpenAPI openApi) {
        context.io().servers().readList(targetClass).forEach(arg_0 -> ((OpenAPI)openApi).addServer(arg_0));
    }

    default public void processJavaSecurity(AnnotationScannerContext context, ClassInfo resourceClass, OpenAPI openApi) {
        JavaSecurityProcessor securityProcessor = context.getJavaSecurityProcessor();
        securityProcessor.initialize(openApi);
        securityProcessor.addDeclaredRolesToScopes((String[])context.annotations().getAnnotationValue((AnnotationTarget)resourceClass, SecurityConstants.DECLARE_ROLES));
        securityProcessor.addRolesAllowedToScopes((String[])context.annotations().getAnnotationValue((AnnotationTarget)resourceClass, SecurityConstants.ROLES_ALLOWED));
    }

    default public void processOperationTags(AnnotationScannerContext context, MethodInfo method, OpenAPI openApi, Set<String> resourceTags, Operation operation) {
        Set<String> tags = this.processTags(context, (AnnotationTarget)method, openApi, true);
        if (tags == null) {
            if (!resourceTags.isEmpty()) {
                operation.setTags(new ArrayList<String>(resourceTags));
            }
        } else if (!tags.isEmpty()) {
            operation.setTags(new ArrayList<String>(tags));
        }
    }

    default public Set<String> processTags(AnnotationScannerContext context, AnnotationTarget target, OpenAPI openApi, boolean nullWhenMissing) {
        if (!context.io().tags().hasRepeatableAnnotation(target)) {
            return nullWhenMissing ? null : Collections.emptySet();
        }
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        context.io().tags().readList(target).stream().filter(tag -> Objects.nonNull(tag.getName())).forEach(tag -> {
            tags.add(tag.getName());
            ModelUtil.addTag(openApi, tag);
        });
        context.io().tags().readReferences(target).forEach(tags::add);
        return tags;
    }

    default public List<MethodInfo> getResourceMethods(AnnotationScannerContext context, ClassInfo resource) {
        Type resourceType = Type.create((DotName)resource.name(), (Type.Kind)Type.Kind.CLASS);
        AugmentedIndexView index = context.getAugmentedIndex();
        Map<ClassInfo, Type> chain = index.inheritanceChain(resource, resourceType);
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        for (ClassInfo classInfo : chain.keySet()) {
            classInfo.methods().stream().filter(method -> !method.isSynthetic()).forEach(methods::add);
            index.interfaces(classInfo).stream().filter(type -> !TypeUtil.knownJavaType(type.name())).map(context.getAugmentedIndex()::getClass).filter(Objects::nonNull).flatMap(iface -> iface.methods().stream()).forEach(methods::add);
        }
        return methods;
    }

    default public Optional<Operation> processOperation(AnnotationScannerContext context, ClassInfo resourceClass, MethodInfo method) {
        MethodInfo conflictingMethod;
        Object operationId;
        if (context.io().operations().isHidden((AnnotationTarget)method)) {
            return Optional.empty();
        }
        OperationImpl operation = (OperationImpl)context.io().operations().read((AnnotationTarget)method);
        if (operation == null) {
            operation = new OperationImpl();
        }
        operation.setMethodRef(JandexUtil.createUniqueMethodReference(resourceClass, method));
        TypeUtil.mapDeprecated(context, (AnnotationTarget)method, operation::getDeprecated, operation::setDeprecated);
        TypeUtil.mapDeprecated(context, (AnnotationTarget)resourceClass, operation::getDeprecated, operation::setDeprecated);
        OpenApiConfig.OperationIdStrategy operationIdStrategy = context.getConfig().getOperationIdStrategy();
        if (operationIdStrategy != null && operation.getOperationId() == null) {
            operationId = null;
            switch (operationIdStrategy) {
                case METHOD: {
                    operationId = method.name();
                    break;
                }
                case CLASS_METHOD: {
                    operationId = resourceClass.name().withoutPackagePrefix() + "_" + method.name();
                    break;
                }
                case PACKAGE_CLASS_METHOD: {
                    operationId = resourceClass.name() + "_" + method.name();
                    break;
                }
            }
            operation.setOperationId((String)operationId);
        }
        if ((operationId = operation.getOperationId()) != null && (conflictingMethod = context.getOperationIdMap().putIfAbsent((String)operationId, method)) != null) {
            ClassInfo conflictingClass = conflictingMethod.declaringClass();
            String className = resourceClass.name().toString();
            String methodName = method.toString();
            String conflictingClassName = conflictingClass.name().toString();
            String conflictingMethodName = conflictingMethod.toString();
            if (context.getConfig().getDuplicateOperationIdBehavior() == OpenApiConfig.DuplicateOperationIdBehavior.WARN) {
                ScannerSPILogging.log.duplicateOperationId((String)operationId, className, methodName, conflictingClassName, conflictingMethodName);
            } else {
                throw ScannerSPIMessages.msg.duplicateOperationId((String)operationId, className, methodName, conflictingClassName, conflictingMethodName);
            }
        }
        return Optional.of(operation);
    }

    default public void setJsonViewContext(AnnotationScannerContext context, Type[] views) {
        this.clearJsonViewContext(context);
        if (views != null && views.length > 0) {
            AugmentedIndexView index = context.getAugmentedIndex();
            Arrays.stream(views).map(viewType -> {
                if (index.containsClass((Type)viewType)) {
                    return index.inheritanceChain(index.getClass((Type)viewType), (Type)viewType).values();
                }
                return Collections.singleton(viewType);
            }).flatMap(Collection::stream).forEach(context.getJsonViews()::add);
        }
    }

    default public void clearJsonViewContext(AnnotationScannerContext context) {
        context.getJsonViews().clear();
    }

    default public void processResponse(AnnotationScannerContext context, ClassInfo resourceClass, MethodInfo method, Operation operation, Map<DotName, Map<String, APIResponse>> exceptionResponseMap) {
        this.setJsonViewContext(context, (Type[])context.annotations().getAnnotationValue((AnnotationTarget)method, JacksonConstants.JSON_VIEW));
        Optional<APIResponses> classResponses = Optional.ofNullable((APIResponses)context.io().responses().read((AnnotationTarget)resourceClass));
        Map<String, APIResponse> classResponse = context.io().responses().readSingle((AnnotationTarget)resourceClass);
        this.addResponses(operation, classResponses, classResponse, false);
        Optional<APIResponses> methodResponses = Optional.ofNullable((APIResponses)context.io().responses().read((AnnotationTarget)method));
        Map<String, APIResponse> methodResponse = context.io().responses().readSingle((AnnotationTarget)method);
        this.addResponses(operation, methodResponses, methodResponse, true);
        context.io().responses().readResponseSchema((AnnotationTarget)method).ifPresent(responseSchema -> this.addApiReponseSchemaFromAnnotation((Map<String, APIResponse>)responseSchema, method, operation));
        if (methodResponses.isPresent() || context.io().responses().getAnnotation((AnnotationTarget)method) == null) {
            this.createResponseFromRestMethod(context, method, operation);
        }
        List methodExceptions = method.exceptions();
        if (exceptionResponseMap != null) {
            methodExceptions.stream().map(Type::name).filter(exceptionResponseMap::containsKey).map(exceptionResponseMap::get).forEach(responseMap -> responseMap.forEach((code, response) -> {
                APIResponses responses = ModelUtil.responses(operation);
                if (!responses.hasAPIResponse(code)) {
                    responses.addAPIResponse(code, response);
                }
            }));
        }
        this.clearJsonViewContext(context);
    }

    default public void addResponses(Operation operation, Optional<APIResponses> responses, Map<String, APIResponse> singleResponse, boolean includeExtensions) {
        responses.ifPresent(resp -> {
            resp.getAPIResponses().forEach((arg_0, arg_1) -> ((APIResponses)ModelUtil.responses(operation)).addAPIResponse(arg_0, arg_1));
            if (includeExtensions && resp.getExtensions() != null) {
                resp.getExtensions().forEach((arg_0, arg_1) -> ((APIResponses)ModelUtil.responses(operation)).addExtension(arg_0, arg_1));
            }
        });
        if (singleResponse != null) {
            singleResponse.forEach((arg_0, arg_1) -> ((APIResponses)ModelUtil.responses(operation)).addAPIResponse(arg_0, arg_1));
        }
    }

    default public void createResponseFromRestMethod(AnnotationScannerContext context, MethodInfo method, Operation operation) {
        Type returnType = context.getResourceTypeResolver().resolve(method.returnType());
        APIResponse response = null;
        int status = this.getDefaultStatus(method);
        String code = String.valueOf(status);
        String description = this.getReasonPhrase(status);
        if (this.isVoidResponse(method)) {
            if (this.generateResponse(code, operation)) {
                response = new APIResponseImpl().description(description);
            }
        } else if (this.generateResponse(code, operation)) {
            response = new APIResponseImpl().description(description);
            if (!(this.isScannerInternalResponse(returnType, context, method) || ModelUtil.responses(operation).getAPIResponse(code) != null && ModelUtil.responses(operation).getAPIResponse(code).getContent() != null)) {
                Schema schema = this.isMultipartOutput(returnType) ? new SchemaImpl().type(Schema.SchemaType.OBJECT) : (this.hasKotlinContinuation(method) ? this.kotlinContinuationToSchema(context, method) : SchemaFactory.typeToSchema(context, returnType, null, context.getExtensions()));
                ContentImpl content = new ContentImpl();
                String[] produces = context.getCurrentProduces();
                if (produces == null || produces.length == 0) {
                    produces = this.getDefaultProduces(context, method);
                }
                if (schema != null && schema.getNullable() == null && TypeUtil.isOptional(returnType)) {
                    schema.setNullable(Boolean.TRUE);
                }
                for (String producesType : produces) {
                    MediaTypeImpl mt = new MediaTypeImpl();
                    mt.setSchema(schema);
                    content.addMediaType(producesType, mt);
                }
                response.setContent((Content)content);
            }
        }
        if (response != null) {
            APIResponses responses = ModelUtil.responses(operation);
            if (responses.hasAPIResponse(code)) {
                APIResponse responseFromAnnotations = responses.getAPIResponse(code);
                response = MergeUtil.mergeObjects(response, responseFromAnnotations);
            }
            responses.addAPIResponse(code, response);
        }
    }

    default public int getDefaultStatus(MethodInfo method) {
        int status = this.isVoidResponse(method) ? (this.isPostMethod(method) ? 201 : (!this.isAsyncResponse(method) ? 204 : 200)) : 200;
        return status;
    }

    default public boolean isVoidResponse(MethodInfo method) {
        return this.isVoidType(method.returnType());
    }

    default public boolean isVoidType(Type type) {
        if (TypeUtil.isVoid(type)) {
            return true;
        }
        if (this.isWrapperType(type)) {
            ParameterizedType parameterizedType = type.asParameterizedType();
            return parameterizedType.arguments().stream().anyMatch(this::isVoidType);
        }
        if (TypeUtil.isWrappedType(type)) {
            return this.isVoidType(TypeUtil.unwrapType(type));
        }
        return false;
    }

    default public boolean isScannerInternalResponse(Type returnType, AnnotationScannerContext context, MethodInfo method) {
        if (this.isScannerInternalResponse(returnType)) {
            return true;
        }
        return this.hasKotlinContinuation(method) && this.isScannerInternalResponse(this.getKotlinContinuationArgument(context, method));
    }

    default public boolean hasKotlinContinuation(MethodInfo method) {
        return method.parameterTypes().stream().anyMatch(this::isKotlinContinuation);
    }

    default public boolean isKotlinContinuation(Type paramType) {
        return KotlinConstants.CONTINUATION.equals((Object)paramType.name());
    }

    default public Type getKotlinContinuationArgument(AnnotationScannerContext context, MethodInfo method) {
        Type type = method.parameterTypes().stream().filter(this::isKotlinContinuation).findFirst().map(context.getResourceTypeResolver()::resolve).orElseThrow(() -> new IllegalStateException("Kotlin Continuation not present"));
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE && (type = (Type)type.asParameterizedType().arguments().get(0)).kind() == Type.Kind.WILDCARD_TYPE) {
            Type extendsBound = type.asWildcardType().extendsBound();
            Type superBound = type.asWildcardType().superBound();
            type = superBound != null ? superBound : extendsBound;
        }
        return type;
    }

    default public Schema kotlinContinuationToSchema(AnnotationScannerContext context, MethodInfo method) {
        Type type = this.getKotlinContinuationArgument(context, method);
        AnnotationInstance schemaAnnotation = context.annotations().getMethodParameterAnnotation(method, type, SchemaConstant.DOTNAME_SCHEMA);
        return SchemaFactory.typeToSchema(context, type, schemaAnnotation, context.getExtensions());
    }

    default public boolean generateResponse(String status, Operation operation) {
        APIResponses responses = operation.getResponses();
        return responses == null || responses.getAPIResponse(status) != null;
    }

    default public void addApiReponseSchemaFromAnnotation(Map<String, APIResponse> responseSchema, MethodInfo method, Operation operation) {
        int status;
        Map.Entry<String, APIResponse> entry = responseSchema.entrySet().iterator().next();
        String responseCode = entry.getKey();
        if (responseCode != null && responseCode.matches("\\d{3}")) {
            status = Integer.parseInt(responseCode);
        } else {
            status = this.getDefaultStatus(method);
            responseCode = String.valueOf(status);
        }
        APIResponse response = entry.getValue();
        if (response.getDescription() == null) {
            response.setDescription(this.getReasonPhrase(status));
        }
        ModelUtil.responses(operation).addAPIResponse(responseCode, response);
    }

    default public void processSecurityRequirementAnnotation(AnnotationScannerContext context, ClassInfo resourceClass, MethodInfo method, Operation operation) {
        List<SecurityRequirement> securityRequirements = context.io().security().readRequirements(method);
        boolean emptyContainerPresent = this.isEmptySecurityRequirements(context, (AnnotationTarget)method);
        if (securityRequirements.isEmpty() && !emptyContainerPresent) {
            securityRequirements = context.io().security().readRequirements(resourceClass);
        }
        if (securityRequirements.isEmpty() && emptyContainerPresent) {
            operation.setSecurity(new ArrayList(0));
        } else {
            securityRequirements.forEach(arg_0 -> ((Operation)operation).addSecurityRequirement(arg_0));
        }
    }

    default public boolean isEmptySecurityRequirements(AnnotationScannerContext context, AnnotationTarget target) {
        return Stream.of(Names.SECURITY_REQUIREMENTS, Names.SECURITY_REQUIREMENTS_SETS).map(name -> context.annotations().getAnnotation(target, (DotName)name)).filter(Objects::nonNull).map(annotation -> (AnnotationInstance[])context.annotations().value((AnnotationInstance)annotation)).anyMatch(values -> values == null || ((AnnotationInstance[])values).length == 0);
    }

    default public void processCallback(AnnotationScannerContext context, MethodInfo method, Operation operation) {
        Map callbacks = context.io().components().callbacks().readMap(method);
        if (!callbacks.isEmpty()) {
            operation.setCallbacks(callbacks);
        }
    }

    default public void processServerAnnotation(AnnotationScannerContext context, MethodInfo method, Operation operation) {
        List<Server> servers = context.io().servers().readList(method);
        if (servers.isEmpty()) {
            servers = context.io().servers().readList(method.declaringClass());
        }
        servers.forEach(arg_0 -> ((Operation)operation).addServer(arg_0));
    }

    default public void processExtensions(AnnotationScannerContext context, MethodInfo method, Operation operation) {
        Map methodExtensions = context.io().extensions().readMap(method);
        if (methodExtensions.isEmpty()) {
            context.io().extensions().readMap(method.declaringClass()).forEach((arg_0, arg_1) -> ((Operation)operation).addExtension(arg_0, arg_1));
        } else {
            methodExtensions.forEach((arg_0, arg_1) -> ((Operation)operation).addExtension(arg_0, arg_1));
        }
    }

    default public void processScannerExtensions(AnnotationScannerContext context, Collection<ClassInfo> applications) {
        for (AnnotationScannerExtension extension : context.getExtensions()) {
            extension.processScannerApplications(this, applications);
        }
    }

    default public RequestBody processRequestBody(AnnotationScannerContext context, MethodInfo method, ResourceParameters params) {
        RequestBody requestBody = null;
        for (AnnotationInstance annotation : context.io().requestBodies().getRepeatableAnnotations((AnnotationTarget)method)) {
            AnnotationInstance schemaAnnotation;
            Schema schema;
            requestBody = context.io().requestBodies().read(annotation);
            Content formBodyContent = params.getFormBodyContent();
            if (formBodyContent != null) {
                requestBody.setContent(MergeUtil.mergeObjects(formBodyContent, requestBody.getContent()));
            }
            Type requestBodyType = null;
            if (annotation.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
                requestBodyType = method.parameterType((int)annotation.target().asMethodParameter().position());
            } else if (annotation.target().kind() == AnnotationTarget.Kind.METHOD) {
                requestBodyType = this.getRequestBodyParameterClassType(context, method, params);
            }
            if (requestBodyType == null || requestBody.getRef() != null) continue;
            Type[] views = (Type[])context.annotations().value(context.annotations().getMethodParameterAnnotation(method, requestBodyType, JacksonConstants.JSON_VIEW));
            this.setJsonViewContext(context, views);
            if (!ModelUtil.requestBodyHasSchema(requestBody) && (schema = SchemaFactory.typeToSchema(context, requestBodyType = context.getResourceTypeResolver().resolve(requestBodyType), schemaAnnotation = context.annotations().getMethodParameterAnnotation(method, requestBodyType, SchemaConstant.DOTNAME_SCHEMA), context.getExtensions())) != null) {
                ModelUtil.setRequestBodySchema(requestBody, schema, this.getConsumes(context));
            }
            if (requestBody.getRequired() == null && TypeUtil.isOptional(requestBodyType)) {
                requestBody.setRequired(Boolean.FALSE);
            }
            this.setRequestBodyConstraints(context, requestBody, method, requestBodyType);
        }
        if (requestBody == null) {
            requestBody = context.io().requestBodies().readRequestSchema(method);
        }
        if ((requestBody == null || requestBody.getContent() == null && requestBody.getRef() == null) && this.getConsumes(context) != null) {
            if (params.getFormBodyContent() != null) {
                if (requestBody == null) {
                    requestBody = new RequestBodyImpl();
                }
                requestBody.setContent(params.getFormBodyContent());
            } else {
                Type requestBodyType = this.getRequestBodyParameterClassType(context, method, params);
                requestBodyType = context.getResourceTypeResolver().resolve(requestBodyType);
                if (requestBodyType != null && !this.isScannerInternalParameter(requestBodyType)) {
                    Type[] views = (Type[])context.annotations().value(context.annotations().getMethodParameterAnnotation(method, requestBodyType, JacksonConstants.JSON_VIEW));
                    this.setJsonViewContext(context, views);
                    SchemaImpl schema = null;
                    if (this.isMultipartInput(requestBodyType)) {
                        schema = new SchemaImpl();
                        schema.setType(Schema.SchemaType.OBJECT);
                    } else {
                        AnnotationInstance schemaAnnotation = context.annotations().getMethodParameterAnnotation(method, requestBodyType, SchemaConstant.DOTNAME_SCHEMA);
                        schema = SchemaFactory.typeToSchema(context, requestBodyType, schemaAnnotation, context.getExtensions());
                    }
                    if (requestBody == null) {
                        requestBody = new RequestBodyImpl();
                    }
                    if (schema != null) {
                        ModelUtil.setRequestBodySchema(requestBody, schema, this.getConsumesForRequestBody(context));
                    }
                    if (requestBody.getRequired() == null && TypeUtil.isOptional(requestBodyType)) {
                        requestBody.setRequired(Boolean.FALSE);
                    }
                    this.setRequestBodyConstraints(context, requestBody, method, requestBodyType);
                }
            }
        }
        this.clearJsonViewContext(context);
        return requestBody;
    }

    default public String[] getConsumes(AnnotationScannerContext context) {
        String[] currentConsumes = context.getCurrentConsumes();
        if (currentConsumes == null || currentConsumes.length == 0) {
            currentConsumes = context.getConfig().getDefaultConsumes().orElse(null);
        }
        return currentConsumes;
    }

    default public String[] getConsumesForRequestBody(AnnotationScannerContext context) {
        String[] currentConsumes = context.getCurrentConsumes();
        if (currentConsumes == null || currentConsumes.length == 0) {
            currentConsumes = context.getDefaultConsumes();
        }
        return currentConsumes;
    }

    default public Type getRequestBodyParameterClassType(AnnotationScannerContext context, MethodInfo method, ResourceParameters params) {
        List methodParams = method.parameterTypes();
        return IntStream.range(0, methodParams.size()).filter(position -> !this.isKotlinContinuation((Type)methodParams.get(position))).filter(position -> !this.isFrameworkContextType((Type)methodParams.get(position))).filter(position -> !this.isPathParameter(context, method.parameterName(position), params)).filter(position -> {
            List<AnnotationInstance> annotations = context.annotations().getMethodParameterAnnotations(method, position);
            return annotations.isEmpty() || !this.containsScannerAnnotations(annotations, context.getExtensions());
        }).mapToObj(methodParams::get).findFirst().orElse(null);
    }

    default public void setRequestBodyConstraints(AnnotationScannerContext context, RequestBody requestBody, MethodInfo method, Type requestBodyType) {
        List<AnnotationInstance> paramAnnotations = context.annotations().getMethodParameterAnnotations(method, requestBodyType);
        Optional<BeanValidationScanner> constraintScanner = context.getBeanValidationScanner();
        if (!paramAnnotations.isEmpty() && constraintScanner.isPresent()) {
            AnnotationTarget paramTarget = paramAnnotations.iterator().next().target();
            Optional.ofNullable(requestBody.getContent()).map(Content::getMediaTypes).map(Map::entrySet).orElseGet(Collections::emptySet).stream().map(Map.Entry::getValue).map(MediaType::getSchema).filter(Objects::nonNull).forEach(schema -> ((BeanValidationScanner)constraintScanner.get()).applyConstraints(paramTarget, (Schema)schema, null, (target, name) -> {
                if (requestBody.getRequired() == null) {
                    requestBody.setRequired(Boolean.TRUE);
                }
            }));
        }
    }

    default public boolean isPathParameter(AnnotationScannerContext context, String name, ResourceParameters params) {
        if (context.getConfig().allowNakedPathParameter().orElse(Boolean.FALSE).booleanValue()) {
            return params.getAllParameters().stream().map(p -> ModelUtil.dereference(context.getOpenApi(), p)).filter(p -> Objects.equals(p.getName(), name)).anyMatch(p -> Objects.equals(p.getIn(), Parameter.In.PATH));
        }
        return false;
    }

    default public boolean isFrameworkContextType(Type type) {
        return false;
    }

    default public String getReasonPhrase(int statusCode) {
        switch (statusCode) {
            case 100: {
                return "Continue";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 102: {
                return "Processing";
            }
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Non-authoritative Information";
            }
            case 204: {
                return "No Content";
            }
            case 205: {
                return "Reset Content";
            }
            case 206: {
                return "Partial Content";
            }
            case 207: {
                return "Multi-Status";
            }
            case 208: {
                return "Already Reported";
            }
            case 226: {
                return "IM Used";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Found";
            }
            case 303: {
                return "See Other";
            }
            case 304: {
                return "Not Modified";
            }
            case 305: {
                return "Use Proxy";
            }
            case 307: {
                return "Temporary Redirect";
            }
            case 308: {
                return "Permanent Redirect";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Timeout";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Payload Too Large";
            }
            case 414: {
                return "Request-URI Too Long";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 416: {
                return "Requested Range Not Satisfiable";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 418: {
                return "I'm a teapot";
            }
            case 421: {
                return "Misdirected Request";
            }
            case 422: {
                return "Unprocessable Entity";
            }
            case 423: {
                return "Locked";
            }
            case 424: {
                return "Failed Dependency";
            }
            case 426: {
                return "Upgrade Required";
            }
            case 428: {
                return "Precondition Required";
            }
            case 429: {
                return "Too Many Requests";
            }
            case 431: {
                return "Request Header Fields Too Large";
            }
            case 444: {
                return "Connection Closed Without Response";
            }
            case 451: {
                return "Unavailable For Legal Reasons";
            }
            case 499: {
                return "Client Closed Request";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
            case 506: {
                return "Variant Also Negotiates";
            }
            case 507: {
                return "Insufficient Storage";
            }
            case 508: {
                return "Loop Detected";
            }
            case 510: {
                return "Not Extended";
            }
            case 511: {
                return "Network Authentication Required";
            }
            case 599: {
                return "Network Connect Timeout Error";
            }
        }
        return "Unknown";
    }
}

