/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.cdi;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessInjectionPoint;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.bval.cdi.BValInterceptor;
import org.apache.tomee.microprofile.jwt.MPJWTFilter;
import org.apache.tomee.microprofile.jwt.MPJWTInitializer;
import org.apache.tomee.microprofile.jwt.cdi.ClaimBean;
import org.apache.tomee.microprofile.jwt.cdi.JsonbProducer;
import org.apache.tomee.microprofile.jwt.config.JWTAuthConfigurationProperties;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.JsonWebToken;

public class MPJWTCDIExtension
implements Extension {
    private static final Predicate<InjectionPoint> NOT_PROVIDERS = ip -> Class.class.isInstance(ip.getType()) || ParameterizedType.class.isInstance(ip.getType()) && ((ParameterizedType)ip.getType()).getRawType() != Provider.class;
    private static final Predicate<InjectionPoint> NOT_INSTANCES = ip -> Class.class.isInstance(ip.getType()) || ParameterizedType.class.isInstance(ip.getType()) && ((ParameterizedType)ip.getType()).getRawType() != Instance.class;
    private static final Map<Type, Type> REPLACED_TYPES = new HashMap<Type, Type>();
    private Set<InjectionPoint> injectionPoints = new HashSet<InjectionPoint>();

    public void collectConfigProducer(@Observes ProcessInjectionPoint<?, ?> pip) {
        Claim claim = (Claim)pip.getInjectionPoint().getAnnotated().getAnnotation(Claim.class);
        if (claim != null) {
            this.injectionPoints.add(pip.getInjectionPoint());
        }
    }

    void pat(@Observes ProcessAnnotatedType<BValInterceptor> stockBvalInterceptor) {
        stockBvalInterceptor.veto();
    }

    public void registerClaimProducer(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        Set types = this.injectionPoints.stream().filter(NOT_PROVIDERS).filter(NOT_INSTANCES).map(ip -> REPLACED_TYPES.getOrDefault(ip.getType(), ip.getType())).collect(Collectors.toSet());
        Set providerTypes = this.injectionPoints.stream().filter(NOT_PROVIDERS.negate()).map(ip -> ((ParameterizedType)ip.getType()).getActualTypeArguments()[0]).collect(Collectors.toSet());
        Set instanceTypes = this.injectionPoints.stream().filter(NOT_INSTANCES.negate()).map(ip -> ((ParameterizedType)ip.getType()).getActualTypeArguments()[0]).collect(Collectors.toSet());
        types.addAll(providerTypes);
        types.addAll(instanceTypes);
        types.stream().map(type -> new ClaimBean(bm, (Type)type)).forEach(arg_0 -> ((AfterBeanDiscovery)abd).addBean(arg_0));
        abd.addBean().id(MPJWTCDIExtension.class.getName() + "#" + JsonWebToken.class.getName()).beanClass(JsonWebToken.class).types(new Type[]{JsonWebToken.class, Object.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(Dependent.class).createWith(ctx -> {
            Principal principal = MPJWTCDIExtension.getContextualReference(Principal.class, bm);
            if (JsonWebToken.class.isInstance(principal)) {
                return JsonWebToken.class.cast(principal);
            }
            return null;
        });
    }

    public void observeBeforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd, BeanManager beanManager) {
        bbd.addAnnotatedType(beanManager.createAnnotatedType(JWTAuthConfigurationProperties.class), "JWTAuthConfigurationProperties");
        bbd.addAnnotatedType(beanManager.createAnnotatedType(JsonbProducer.class), "JsonbProducer");
        bbd.addAnnotatedType(beanManager.createAnnotatedType(MPJWTFilter.class), "MPJWTFilter");
        bbd.addAnnotatedType(beanManager.createAnnotatedType(MPJWTInitializer.class), "MPJWTInitializer");
        bbd.addAnnotatedType(beanManager.createAnnotatedType(org.apache.tomee.microprofile.jwt.bval.BValInterceptor.class), "BValInterceptor");
    }

    public static <T> T getContextualReference(Class<T> type, BeanManager beanManager) {
        Set beans = beanManager.getBeans(type, new Annotation[0]);
        if (beans == null || beans.isEmpty()) {
            throw new IllegalStateException("Could not find beans for Type=" + String.valueOf(type));
        }
        Bean bean = beanManager.resolve(beans);
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
        return (T)beanManager.getReference(bean, type, creationalContext);
    }

    static {
        REPLACED_TYPES.put(Double.TYPE, (Type)((Object)Double.class));
        REPLACED_TYPES.put(Integer.TYPE, (Type)((Object)Integer.class));
        REPLACED_TYPES.put(Float.TYPE, (Type)((Object)Float.class));
        REPLACED_TYPES.put(Long.TYPE, (Type)((Object)Long.class));
        REPLACED_TYPES.put(Boolean.TYPE, (Type)((Object)Boolean.class));
    }
}

