/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.PathProcessor;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.EmptyTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalProduct;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalRing;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class FormatStep<S>
extends MapStep<S, String>
implements ByModulating,
TraversalParent,
Scoping,
PathProcessor {
    private static final String FROM_BY = "_";
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("(?<!%)%\\{(.*?)\\}");
    private String format;
    private Set<String> variables;
    private TraversalRing<S, String> traversalRing = new TraversalRing(new Traversal.Admin[0]);
    private Set<String> keepLabels;

    public FormatStep(Traversal.Admin traversal, String format) {
        super(traversal);
        if (null == format) {
            throw new IllegalArgumentException("Format string for Format step can't be null.");
        }
        this.format = format;
        this.variables = this.getVariables();
    }

    @Override
    protected Traverser.Admin<String> processNextStart() {
        Object traverser = this.starts.next();
        boolean productive = true;
        int lastIndex = 0;
        StringBuilder output = new StringBuilder();
        Matcher matcher = VARIABLE_PATTERN.matcher(this.format);
        Object current = traverser.get();
        while (matcher.find()) {
            TraversalProduct product;
            Property prop;
            String varName = matcher.group(1);
            if (varName == null) continue;
            if (!varName.equals(FROM_BY) && current instanceof Element && (prop = ((Element)current).property(varName)) != null && prop.isPresent()) {
                output.append(this.format, lastIndex, matcher.start()).append(prop.value());
                lastIndex = matcher.end();
                continue;
            }
            TraversalProduct traversalProduct = product = varName.equals(FROM_BY) ? TraversalUtil.produce(traverser, this.traversalRing.next()) : TraversalUtil.produce(this.getNullableScopeValue(Pop.last, varName, (Traverser.Admin<?>)traverser), null);
            if (!product.isProductive() || product.get() == null) {
                productive = false;
                break;
            }
            output.append(this.format, lastIndex, matcher.start()).append(product.get());
            lastIndex = matcher.end();
        }
        if (lastIndex < this.format.length()) {
            output.append(this.format, lastIndex, this.format.length());
        }
        this.traversalRing.reset();
        return productive ? PathProcessor.processTraverserPathLabels(traverser.split(output.toString(), this), this.keepLabels) : EmptyTraverser.instance();
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.format, this.traversalRing);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return Objects.hash(result, this.format, this.traversalRing);
    }

    public List<Traversal.Admin<S, String>> getLocalChildren() {
        return this.traversalRing.getTraversals();
    }

    @Override
    public void reset() {
        super.reset();
        this.traversalRing.reset();
    }

    @Override
    public FormatStep<S> clone() {
        FormatStep clone = (FormatStep)super.clone();
        clone.format = this.format;
        clone.variables = this.variables;
        clone.traversalRing = this.traversalRing;
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.traversalRing.getTraversals().forEach(this::integrateChild);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT, TraverserRequirement.SIDE_EFFECTS);
    }

    @Override
    public Set<String> getScopeKeys() {
        return this.variables;
    }

    @Override
    public void setKeepLabels(Set<String> labels) {
        this.keepLabels = labels;
    }

    @Override
    public Set<String> getKeepLabels() {
        return this.keepLabels;
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> selectTraversal) {
        this.traversalRing.addTraversal(this.integrateChild(selectTraversal));
    }

    @Override
    public void replaceLocalChild(Traversal.Admin<?, ?> oldTraversal, Traversal.Admin<?, ?> newTraversal) {
        this.traversalRing.replaceTraversal(oldTraversal, this.integrateChild(newTraversal));
    }

    private Set<String> getVariables() {
        Matcher matcher = VARIABLE_PATTERN.matcher(this.format);
        LinkedHashSet<String> variables = new LinkedHashSet<String>();
        while (matcher.find()) {
            String varName = matcher.group(1);
            if (varName == null || varName.equals(FROM_BY)) continue;
            variables.add(varName);
        }
        return variables;
    }
}

