/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.remote.traversal.step.map;

import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnectionException;
import org.apache.tinkerpop.gremlin.process.remote.traversal.RemoteTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class RemoteStep<S, E>
extends AbstractStep<S, E> {
    private transient RemoteConnection remoteConnection;
    private RemoteTraversal<?, E> remoteTraversal;
    private final AtomicReference<CompletableFuture<Traversal<?, E>>> traversalFuture = new AtomicReference<Object>(null);

    public RemoteStep(Traversal.Admin traversal, RemoteConnection remoteConnection) {
        super(traversal);
        this.remoteConnection = remoteConnection;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.remoteConnection);
    }

    @Override
    protected Traverser.Admin<E> processNextStart() throws NoSuchElementException {
        if (null == this.remoteTraversal) {
            try {
                this.promise().join();
            }
            catch (CompletionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new IllegalStateException(cause);
            }
        }
        return this.remoteTraversal.nextTraverser();
    }

    public CompletableFuture<Traversal<?, E>> promise() {
        try {
            if (null == this.traversalFuture.get()) {
                this.traversalFuture.set((CompletableFuture<Traversal<?, E>>)this.remoteConnection.submitAsync(this.traversal.getGremlinLang()).thenApply(t -> {
                    this.remoteTraversal = t;
                    return this.traversal;
                }));
            }
            return this.traversalFuture.get();
        }
        catch (RemoteConnectionException rce) {
            throw new IllegalStateException(rce);
        }
    }
}

