/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Merge;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ConstantTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.GValueConstantTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.IdentityTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AbstractMergeElementStepPlaceholder;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MergeEdgeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MergeElementStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.T;

public class MergeEdgeStepPlaceholder<S>
extends AbstractMergeElementStepPlaceholder<S, Edge> {
    private static final Set allowedTokens = new LinkedHashSet<Enum>(Arrays.asList(new Enum[]{T.id, T.label, Direction.IN, Direction.OUT}));
    private Traversal.Admin<S, Map<Object, Object>> outVTraversal = null;
    private Traversal.Admin<S, Map<Object, Object>> inVTraversal = null;
    private final boolean isStart;

    public static void validateMapInput(Map map, boolean ignoreTokens) {
        MergeElementStep.validate(map, ignoreTokens, allowedTokens, "mergeE");
    }

    public MergeEdgeStepPlaceholder(Traversal.Admin traversal, boolean isStart) {
        this(traversal, isStart, new IdentityTraversal<Map<Object, Object>>());
    }

    public MergeEdgeStepPlaceholder(Traversal.Admin traversal, boolean isStart, Map<Object, Object> merge) {
        this(traversal, isStart, new ConstantTraversal(merge));
        MergeEdgeStepPlaceholder.validateMapInput(merge, false);
    }

    public MergeEdgeStepPlaceholder(Traversal.Admin traversal, boolean isStart, GValue<Map<Object, Object>> merge) {
        this(traversal, isStart, new GValueConstantTraversal(merge));
        MergeEdgeStepPlaceholder.validateMapInput(merge.get(), false);
    }

    public MergeEdgeStepPlaceholder(Traversal.Admin traversal, boolean isStart, Traversal.Admin<?, Map<Object, Object>> mergeTraversal) {
        super(traversal, mergeTraversal, isStart);
        this.isStart = isStart;
        this.mergeTraversal = mergeTraversal;
        if (mergeTraversal instanceof GValueConstantTraversal && ((GValueConstantTraversal)mergeTraversal).isParameterized()) {
            traversal.getGValueManager().register(((GValueConstantTraversal)mergeTraversal).getGValue());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MergeEdgeStepPlaceholder that = (MergeEdgeStepPlaceholder)o;
        return Objects.equals(this.outVTraversal, that.outVTraversal) && Objects.equals(this.inVTraversal, that.inVTraversal);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.outVTraversal, this.inVTraversal);
    }

    public MergeEdgeStep<S> asConcreteStep() {
        MergeEdgeStep<S> step = new MergeEdgeStep<S>(this.traversal, this.isStart, this.mergeTraversal instanceof GValueConstantTraversal ? ((GValueConstantTraversal)this.mergeTraversal).getConstantTraversal() : this.mergeTraversal);
        step.setOnCreate(this.onCreateTraversal instanceof GValueConstantTraversal ? ((GValueConstantTraversal)this.onCreateTraversal).getConstantTraversal() : this.onCreateTraversal);
        step.setOnMatch(this.onMatchTraversal instanceof GValueConstantTraversal ? ((GValueConstantTraversal)this.onMatchTraversal).getConstantTraversal() : this.onMatchTraversal);
        for (Map.Entry entry : this.properties.entrySet()) {
            for (Object value : (List)entry.getValue()) {
                step.addProperty(entry.getKey(), value);
            }
        }
        if (this.inVTraversal != null) {
            step.addChildOption(Merge.inV, this.inVTraversal);
        }
        if (this.outVTraversal != null) {
            step.addChildOption(Merge.outV, this.outVTraversal);
        }
        TraversalHelper.copyLabels(this, step, false);
        return step;
    }

    @Override
    public void addChildOption(Merge token, Traversal.Admin traversalOption) {
        if (token == Merge.onCreate) {
            this.setOnCreate(traversalOption);
        } else if (token == Merge.onMatch) {
            this.setOnMatch(traversalOption);
        } else if (token == Merge.outV) {
            this.outVTraversal = traversalOption;
        } else if (token == Merge.inV) {
            this.inVTraversal = traversalOption;
        } else {
            throw new UnsupportedOperationException(String.format("Option %s for Merge is not supported", token.name()));
        }
    }
}

