/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.ListFunction;

public final class DisjunctStep<S, E>
extends ScalarMapStep<S, Set<?>>
implements TraversalParent,
ListFunction {
    private Traversal.Admin<S, E> valueTraversal;
    private Object parameterItems;

    public DisjunctStep(Traversal.Admin traversal, Object values) {
        super(traversal);
        if (values instanceof Traversal) {
            this.valueTraversal = this.integrateChild(((Traversal)values).asAdmin());
        } else {
            this.parameterItems = values;
        }
    }

    public Traversal.Admin<S, E> getValueTraversal() {
        return this.valueTraversal;
    }

    public Object getParameterItems() {
        return this.parameterItems;
    }

    @Override
    public String getStepName() {
        return "disjunct";
    }

    @Override
    protected Set<?> map(Traverser.Admin<S> traverser) {
        Set setA = this.convertTraverserToSet(traverser);
        Set setB = null != this.valueTraversal ? this.convertTraversalToSet(traverser, this.valueTraversal) : this.convertArgumentToSet(this.parameterItems);
        HashSet disjunctSet = new HashSet();
        if (setA.size() == 0) {
            return setB;
        }
        if (setB.size() == 0) {
            return setA;
        }
        for (Object item : setA) {
            if (setB.contains(item)) continue;
            disjunctSet.add(item);
        }
        for (Object item : setB) {
            if (setA.contains(item)) continue;
            disjunctSet.add(item);
        }
        return disjunctSet;
    }

    @Override
    public List<Traversal.Admin<S, E>> getLocalChildren() {
        return null == this.valueTraversal ? Collections.emptyList() : Collections.singletonList(this.valueTraversal);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(new TraverserRequirement[0]);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        if (this.valueTraversal != null) {
            this.integrateChild(this.valueTraversal);
        }
    }

    @Override
    public DisjunctStep<S, E> clone() {
        DisjunctStep clone = (DisjunctStep)super.clone();
        if (null != this.valueTraversal) {
            clone.valueTraversal = this.valueTraversal.clone();
        } else {
            clone.parameterItems = this.parameterItems;
        }
        return clone;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return Objects.hash(result, this.valueTraversal, this.parameterItems);
    }
}

