/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.kryo.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.tinkerpop.shaded.kryo.KryoException;

public class Output
extends OutputStream {
    protected int maxCapacity;
    protected long total;
    protected int position;
    protected int capacity;
    protected byte[] buffer;
    protected OutputStream outputStream;

    public Output() {
    }

    public Output(int bufferSize) {
        this(bufferSize, bufferSize);
    }

    public Output(int bufferSize, int maxBufferSize) {
        if (maxBufferSize < -1) {
            throw new IllegalArgumentException("maxBufferSize cannot be < -1: " + maxBufferSize);
        }
        this.capacity = bufferSize;
        this.maxCapacity = maxBufferSize == -1 ? Integer.MAX_VALUE : maxBufferSize;
        this.buffer = new byte[bufferSize];
    }

    public Output(byte[] buffer) {
        this(buffer, buffer.length);
    }

    public Output(byte[] buffer, int maxBufferSize) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null.");
        }
        this.setBuffer(buffer, maxBufferSize);
    }

    public Output(OutputStream outputStream) {
        this(4096, 4096);
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream cannot be null.");
        }
        this.outputStream = outputStream;
    }

    public Output(OutputStream outputStream, int bufferSize) {
        this(bufferSize, bufferSize);
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream cannot be null.");
        }
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.position = 0;
        this.total = 0L;
    }

    public void setBuffer(byte[] buffer) {
        this.setBuffer(buffer, buffer.length);
    }

    public void setBuffer(byte[] buffer, int maxBufferSize) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null.");
        }
        if (maxBufferSize < -1) {
            throw new IllegalArgumentException("maxBufferSize cannot be < -1: " + maxBufferSize);
        }
        this.buffer = buffer;
        this.maxCapacity = maxBufferSize == -1 ? Integer.MAX_VALUE : maxBufferSize;
        this.capacity = buffer.length;
        this.position = 0;
        this.total = 0L;
        this.outputStream = null;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public byte[] toBytes() {
        byte[] newBuffer = new byte[this.position];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.position);
        return newBuffer;
    }

    public int position() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public long total() {
        return this.total + (long)this.position;
    }

    public void clear() {
        this.position = 0;
        this.total = 0L;
    }

    protected boolean require(int required) throws KryoException {
        if (this.capacity - this.position >= required) {
            return false;
        }
        if (required > this.maxCapacity) {
            throw new KryoException("Buffer overflow. Max capacity: " + this.maxCapacity + ", required: " + required);
        }
        this.flush();
        while (this.capacity - this.position < required) {
            if (this.capacity == this.maxCapacity) {
                throw new KryoException("Buffer overflow. Available: " + (this.capacity - this.position) + ", required: " + required);
            }
            if (this.capacity == 0) {
                this.capacity = 1;
            }
            this.capacity = Math.min(this.capacity * 2, this.maxCapacity);
            if (this.capacity < 0) {
                this.capacity = this.maxCapacity;
            }
            byte[] newBuffer = new byte[this.capacity];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.position);
            this.buffer = newBuffer;
        }
        return true;
    }

    public void flush() throws KryoException {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.write(this.buffer, 0, this.position);
        }
        catch (IOException ex) {
            throw new KryoException(ex);
        }
        this.total += (long)this.position;
        this.position = 0;
    }

    public void close() throws KryoException {
        this.flush();
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void write(int value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = (byte)value;
    }

    public void write(byte[] bytes) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void write(byte[] bytes, int offset, int length) throws KryoException {
        this.writeBytes(bytes, offset, length);
    }

    public void writeByte(byte value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = value;
    }

    public void writeByte(int value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = (byte)value;
    }

    public void writeBytes(byte[] bytes) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void writeBytes(byte[] bytes, int offset, int count) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int copyCount = Math.min(this.capacity - this.position, count);
        while (true) {
            System.arraycopy(bytes, offset, this.buffer, this.position, copyCount);
            this.position += copyCount;
            if ((count -= copyCount) == 0) {
                return;
            }
            offset += copyCount;
            copyCount = Math.min(this.capacity, count);
            this.require(copyCount);
        }
    }

    public void writeInt(int value) throws KryoException {
        this.require(4);
        byte[] buffer = this.buffer;
        buffer[this.position++] = (byte)(value >> 24);
        buffer[this.position++] = (byte)(value >> 16);
        buffer[this.position++] = (byte)(value >> 8);
        buffer[this.position++] = (byte)value;
    }

    public int writeInt(int value, boolean optimizePositive) throws KryoException {
        return this.writeVarInt(value, optimizePositive);
    }

    public int writeVarInt(int value, boolean optimizePositive) throws KryoException {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 31;
        }
        if (value >>> 7 == 0) {
            this.require(1);
            this.buffer[this.position++] = (byte)value;
            return 1;
        }
        if (value >>> 14 == 0) {
            this.require(2);
            this.buffer[this.position++] = (byte)(value & 0x7F | 0x80);
            this.buffer[this.position++] = (byte)(value >>> 7);
            return 2;
        }
        if (value >>> 21 == 0) {
            this.require(3);
            this.buffer[this.position++] = (byte)(value & 0x7F | 0x80);
            this.buffer[this.position++] = (byte)(value >>> 7 | 0x80);
            this.buffer[this.position++] = (byte)(value >>> 14);
            return 3;
        }
        if (value >>> 28 == 0) {
            this.require(4);
            this.buffer[this.position++] = (byte)(value & 0x7F | 0x80);
            this.buffer[this.position++] = (byte)(value >>> 7 | 0x80);
            this.buffer[this.position++] = (byte)(value >>> 14 | 0x80);
            this.buffer[this.position++] = (byte)(value >>> 21);
            return 4;
        }
        this.require(5);
        this.buffer[this.position++] = (byte)(value & 0x7F | 0x80);
        this.buffer[this.position++] = (byte)(value >>> 7 | 0x80);
        this.buffer[this.position++] = (byte)(value >>> 14 | 0x80);
        this.buffer[this.position++] = (byte)(value >>> 21 | 0x80);
        this.buffer[this.position++] = (byte)(value >>> 28);
        return 5;
    }

    public void writeString(String value) throws KryoException {
        if (value == null) {
            this.writeByte(128);
            return;
        }
        int charCount = value.length();
        if (charCount == 0) {
            this.writeByte(129);
            return;
        }
        boolean ascii = false;
        if (charCount > 1 && charCount < 64) {
            ascii = true;
            for (int i = 0; i < charCount; ++i) {
                char c = value.charAt(i);
                if (c <= '\u007f') continue;
                ascii = false;
                break;
            }
        }
        if (ascii) {
            if (this.capacity - this.position < charCount) {
                this.writeAscii_slow(value, charCount);
            } else {
                value.getBytes(0, charCount, this.buffer, this.position);
                this.position += charCount;
            }
            int n = this.position - 1;
            this.buffer[n] = (byte)(this.buffer[n] | 0x80);
        } else {
            int charIndex;
            this.writeUtf8Length(charCount + 1);
            if (this.capacity - this.position >= charCount) {
                char c;
                byte[] buffer = this.buffer;
                int position = this.position;
                for (charIndex = 0; charIndex < charCount && (c = value.charAt(charIndex)) <= '\u007f'; ++charIndex) {
                    buffer[position++] = (byte)c;
                }
                this.position = position;
            }
            if (charIndex < charCount) {
                this.writeString_slow(value, charCount, charIndex);
            }
        }
    }

    public void writeString(CharSequence value) throws KryoException {
        int charIndex;
        if (value == null) {
            this.writeByte(128);
            return;
        }
        int charCount = value.length();
        if (charCount == 0) {
            this.writeByte(129);
            return;
        }
        this.writeUtf8Length(charCount + 1);
        if (this.capacity - this.position >= charCount) {
            char c;
            byte[] buffer = this.buffer;
            int position = this.position;
            for (charIndex = 0; charIndex < charCount && (c = value.charAt(charIndex)) <= '\u007f'; ++charIndex) {
                buffer[position++] = (byte)c;
            }
            this.position = position;
        }
        if (charIndex < charCount) {
            this.writeString_slow(value, charCount, charIndex);
        }
    }

    public void writeAscii(String value) throws KryoException {
        if (value == null) {
            this.writeByte(128);
            return;
        }
        int charCount = value.length();
        switch (charCount) {
            case 0: {
                this.writeByte(129);
                return;
            }
            case 1: {
                this.writeByte(130);
                this.writeByte(value.charAt(0));
                return;
            }
        }
        if (this.capacity - this.position < charCount) {
            this.writeAscii_slow(value, charCount);
        } else {
            value.getBytes(0, charCount, this.buffer, this.position);
            this.position += charCount;
        }
        int n = this.position - 1;
        this.buffer[n] = (byte)(this.buffer[n] | 0x80);
    }

    private void writeUtf8Length(int value) {
        if (value >>> 6 == 0) {
            this.require(1);
            this.buffer[this.position++] = (byte)(value | 0x80);
        } else if (value >>> 13 == 0) {
            this.require(2);
            byte[] buffer = this.buffer;
            buffer[this.position++] = (byte)(value | 0x40 | 0x80);
            buffer[this.position++] = (byte)(value >>> 6);
        } else if (value >>> 20 == 0) {
            this.require(3);
            byte[] buffer = this.buffer;
            buffer[this.position++] = (byte)(value | 0x40 | 0x80);
            buffer[this.position++] = (byte)(value >>> 6 | 0x80);
            buffer[this.position++] = (byte)(value >>> 13);
        } else if (value >>> 27 == 0) {
            this.require(4);
            byte[] buffer = this.buffer;
            buffer[this.position++] = (byte)(value | 0x40 | 0x80);
            buffer[this.position++] = (byte)(value >>> 6 | 0x80);
            buffer[this.position++] = (byte)(value >>> 13 | 0x80);
            buffer[this.position++] = (byte)(value >>> 20);
        } else {
            this.require(5);
            byte[] buffer = this.buffer;
            buffer[this.position++] = (byte)(value | 0x40 | 0x80);
            buffer[this.position++] = (byte)(value >>> 6 | 0x80);
            buffer[this.position++] = (byte)(value >>> 13 | 0x80);
            buffer[this.position++] = (byte)(value >>> 20 | 0x80);
            buffer[this.position++] = (byte)(value >>> 27);
        }
    }

    private void writeString_slow(CharSequence value, int charCount, int charIndex) {
        while (charIndex < charCount) {
            char c;
            if (this.position == this.capacity) {
                this.require(Math.min(this.capacity, charCount - charIndex));
            }
            if ((c = value.charAt(charIndex)) <= '\u007f') {
                this.buffer[this.position++] = (byte)c;
            } else if (c > '\u07ff') {
                this.buffer[this.position++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.require(2);
                this.buffer[this.position++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buffer[this.position++] = (byte)(0x80 | c & 0x3F);
            } else {
                this.buffer[this.position++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.require(1);
                this.buffer[this.position++] = (byte)(0x80 | c & 0x3F);
            }
            ++charIndex;
        }
    }

    private void writeAscii_slow(String value, int charCount) throws KryoException {
        byte[] buffer = this.buffer;
        int charIndex = 0;
        int charsToWrite = Math.min(charCount, this.capacity - this.position);
        while (charIndex < charCount) {
            value.getBytes(charIndex, charIndex + charsToWrite, buffer, this.position);
            this.position += charsToWrite;
            if (!this.require(charsToWrite = Math.min(charCount - (charIndex += charsToWrite), this.capacity))) continue;
            buffer = this.buffer;
        }
    }

    public void writeFloat(float value) throws KryoException {
        this.writeInt(Float.floatToIntBits(value));
    }

    public int writeFloat(float value, float precision, boolean optimizePositive) throws KryoException {
        return this.writeInt((int)(value * precision), optimizePositive);
    }

    public void writeShort(int value) throws KryoException {
        this.require(2);
        this.buffer[this.position++] = (byte)(value >>> 8);
        this.buffer[this.position++] = (byte)value;
    }

    public void writeLong(long value) throws KryoException {
        this.require(8);
        byte[] buffer = this.buffer;
        buffer[this.position++] = (byte)(value >>> 56);
        buffer[this.position++] = (byte)(value >>> 48);
        buffer[this.position++] = (byte)(value >>> 40);
        buffer[this.position++] = (byte)(value >>> 32);
        buffer[this.position++] = (byte)(value >>> 24);
        buffer[this.position++] = (byte)(value >>> 16);
        buffer[this.position++] = (byte)(value >>> 8);
        buffer[this.position++] = (byte)value;
    }

    public int writeLong(long value, boolean optimizePositive) throws KryoException {
        return this.writeVarLong(value, optimizePositive);
    }

    public int writeVarLong(long value, boolean optimizePositive) throws KryoException {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 63;
        }
        if (value >>> 7 == 0L) {
            this.require(1);
            this.buffer[this.position++] = (byte)value;
            return 1;
        }
        if (value >>> 14 == 0L) {
            this.require(2);
            this.buffer[this.position++] = (byte)(value & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 7);
            return 2;
        }
        if (value >>> 21 == 0L) {
            this.require(3);
            this.buffer[this.position++] = (byte)(value & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 14);
            return 3;
        }
        if (value >>> 28 == 0L) {
            this.require(4);
            this.buffer[this.position++] = (byte)(value & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 21);
            return 4;
        }
        if (value >>> 35 == 0L) {
            this.require(5);
            this.buffer[this.position++] = (byte)(value & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 21 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 28);
            return 5;
        }
        if (value >>> 42 == 0L) {
            this.require(6);
            this.buffer[this.position++] = (byte)(value & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 21 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 28 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 35);
            return 6;
        }
        if (value >>> 49 == 0L) {
            this.require(7);
            this.buffer[this.position++] = (byte)(value & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 21 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 28 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 35 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 42);
            return 7;
        }
        if (value >>> 56 == 0L) {
            this.require(8);
            this.buffer[this.position++] = (byte)(value & 0x7FL | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 7 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 14 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 21 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 28 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 35 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 42 | 0x80L);
            this.buffer[this.position++] = (byte)(value >>> 49);
            return 8;
        }
        this.require(9);
        this.buffer[this.position++] = (byte)(value & 0x7FL | 0x80L);
        this.buffer[this.position++] = (byte)(value >>> 7 | 0x80L);
        this.buffer[this.position++] = (byte)(value >>> 14 | 0x80L);
        this.buffer[this.position++] = (byte)(value >>> 21 | 0x80L);
        this.buffer[this.position++] = (byte)(value >>> 28 | 0x80L);
        this.buffer[this.position++] = (byte)(value >>> 35 | 0x80L);
        this.buffer[this.position++] = (byte)(value >>> 42 | 0x80L);
        this.buffer[this.position++] = (byte)(value >>> 49 | 0x80L);
        this.buffer[this.position++] = (byte)(value >>> 56);
        return 9;
    }

    public void writeBoolean(boolean value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        this.buffer[this.position++] = (byte)(value ? 1 : 0);
    }

    public void writeChar(char value) throws KryoException {
        this.require(2);
        this.buffer[this.position++] = (byte)(value >>> 8);
        this.buffer[this.position++] = (byte)value;
    }

    public void writeDouble(double value) throws KryoException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public int writeDouble(double value, double precision, boolean optimizePositive) throws KryoException {
        return this.writeLong((long)(value * precision), optimizePositive);
    }

    public static int intLength(int value, boolean optimizePositive) {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 31;
        }
        if (value >>> 7 == 0) {
            return 1;
        }
        if (value >>> 14 == 0) {
            return 2;
        }
        if (value >>> 21 == 0) {
            return 3;
        }
        if (value >>> 28 == 0) {
            return 4;
        }
        return 5;
    }

    public static int longLength(long value, boolean optimizePositive) {
        if (!optimizePositive) {
            value = value << 1 ^ value >> 63;
        }
        if (value >>> 7 == 0L) {
            return 1;
        }
        if (value >>> 14 == 0L) {
            return 2;
        }
        if (value >>> 21 == 0L) {
            return 3;
        }
        if (value >>> 28 == 0L) {
            return 4;
        }
        if (value >>> 35 == 0L) {
            return 5;
        }
        if (value >>> 42 == 0L) {
            return 6;
        }
        if (value >>> 49 == 0L) {
            return 7;
        }
        if (value >>> 56 == 0L) {
            return 8;
        }
        return 9;
    }

    public void writeInts(int[] object, boolean optimizePositive) throws KryoException {
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            this.writeInt(object[i], optimizePositive);
        }
    }

    public void writeLongs(long[] object, boolean optimizePositive) throws KryoException {
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            this.writeLong(object[i], optimizePositive);
        }
    }

    public void writeInts(int[] object) throws KryoException {
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            this.writeInt(object[i]);
        }
    }

    public void writeLongs(long[] object) throws KryoException {
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            this.writeLong(object[i]);
        }
    }

    public void writeFloats(float[] object) throws KryoException {
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            this.writeFloat(object[i]);
        }
    }

    public void writeShorts(short[] object) throws KryoException {
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            this.writeShort(object[i]);
        }
    }

    public void writeChars(char[] object) throws KryoException {
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            this.writeChar(object[i]);
        }
    }

    public void writeDoubles(double[] object) throws KryoException {
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            this.writeDouble(object[i]);
        }
    }
}

