/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml.xwpf.ml2006;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.ooxml.xwpf.ml2006.AbstractPartHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class BinaryDataHandler
extends AbstractPartHandler {
    final Base64 base64 = new Base64();
    private final XHTMLContentHandler handler;
    private final Metadata metadata;
    private final ParseContext parseContext;
    private boolean inBinaryData = false;
    private StringBuilder buffer = new StringBuilder();

    public BinaryDataHandler(XHTMLContentHandler handler, Metadata metadata, ParseContext context) {
        this.handler = handler;
        this.metadata = metadata;
        this.parseContext = context;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endPart() throws SAXException, TikaException {
        if (this.hasData()) {
            EmbeddedDocumentExtractor embeddedDocumentExtractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor(this.parseContext);
            Metadata embeddedMetadata = new Metadata();
            try (TikaInputStream stream = TikaInputStream.get(this.getInputStream());){
                embeddedDocumentExtractor.parseEmbedded(stream, this.handler, embeddedMetadata, true);
            }
            catch (IOException e) {
                throw new TikaException("error in finishing part", e);
            }
            this.buffer.setLength(0);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (uri.equals("http://schemas.microsoft.com/office/2006/xmlPackage") && localName.equals("binaryData")) {
            this.inBinaryData = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri.equals("http://schemas.microsoft.com/office/2006/xmlPackage") && localName.equals("binaryData")) {
            this.inBinaryData = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inBinaryData) {
            this.buffer.append(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public String getContentType() {
        return "";
    }

    boolean hasData() {
        return this.buffer.length() > 0;
    }

    private InputStream getInputStream() throws IOException {
        byte[] bytes = this.base64.decode(this.buffer.toString());
        return UnsynchronizedByteArrayInputStream.builder().setByteArray(bytes).get();
    }
}

