/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.sl.usermodel.Placeholder;
import org.apache.poi.xslf.extractor.XSLFExtractor;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFComment;
import org.apache.poi.xslf.usermodel.XSLFCommentAuthors;
import org.apache.poi.xslf.usermodel.XSLFGraphicFrame;
import org.apache.poi.xslf.usermodel.XSLFGroupShape;
import org.apache.poi.xslf.usermodel.XSLFHyperlink;
import org.apache.poi.xslf.usermodel.XSLFNotes;
import org.apache.poi.xslf.usermodel.XSLFNotesMaster;
import org.apache.poi.xslf.usermodel.XSLFPictureShape;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import org.apache.poi.xslf.usermodel.XSLFSlideMaster;
import org.apache.poi.xslf.usermodel.XSLFSlideShow;
import org.apache.poi.xslf.usermodel.XSLFTable;
import org.apache.poi.xslf.usermodel.XSLFTableCell;
import org.apache.poi.xslf.usermodel.XSLFTableRow;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xslf.usermodel.XSLFTextRun;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.parser.microsoft.ooxml.OOXMLTikaBodyPartHandler;
import org.apache.tika.parser.microsoft.ooxml.OOXMLWordAndPowerPointTextHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPicture;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideIdList;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideIdListEntry;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XSLFPowerPointExtractorDecorator
extends AbstractOOXMLExtractor {
    private static final String HANDOUT_MASTER = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/handoutMaster";
    private Metadata metadata;

    public XSLFPowerPointExtractorDecorator(Metadata metadata, ParseContext context, XSLFExtractor extractor) {
        super(context, extractor);
        this.metadata = metadata;
    }

    @Override
    protected void buildXHTML(XHTMLContentHandler xhtml) throws SAXException, IOException {
        XMLSlideShow slideShow = (XMLSlideShow)this.extractor.getDocument();
        XSLFCommentAuthors commentAuthors = slideShow.getCommentAuthors();
        List<XSLFSlide> slides = slideShow.getSlides();
        for (XSLFSlide slide : slides) {
            List<XSLFComment> comments;
            XSLFNotes slideNotes;
            Object slideDesc;
            if (slide.getPackagePart() != null && slide.getPackagePart().getPartName() != null) {
                slideDesc = this.getJustFileName(slide.getPackagePart().getPartName().toString());
                slideDesc = (String)slideDesc + "_";
            } else {
                slideDesc = null;
            }
            xhtml.startElement("div", "class", "slide-content");
            this.extractContent(slide.getShapes(), false, xhtml, (String)slideDesc);
            xhtml.endElement("div");
            if (this.config.isIncludeSlideMasterContent()) {
                xhtml.startElement("div", "class", "slide-master-content");
                XSLFSlideLayout slideLayout = slide.getMasterSheet();
                this.extractContent(slideLayout.getShapes(), true, xhtml, null);
                xhtml.endElement("div");
                XSLFSlideMaster slideMaster = slideLayout.getMasterSheet();
                this.extractContent(slideMaster.getShapes(), true, xhtml, null);
            }
            if (this.config.isIncludeSlideNotes() && (slideNotes = slide.getNotes()) != null) {
                xhtml.startElement("div", "class", "slide-notes");
                this.extractContent(slideNotes.getShapes(), false, xhtml, (String)slideDesc);
                XSLFNotesMaster notesMaster = slideNotes.getMasterSheet();
                if (notesMaster != null) {
                    this.extractContent(notesMaster.getShapes(), true, xhtml, null);
                }
                xhtml.endElement("div");
            }
            if ((comments = slide.getComments()) != null) {
                StringBuilder authorStringBuilder = new StringBuilder();
                for (XSLFComment comment : comments) {
                    authorStringBuilder.setLength(0);
                    xhtml.startElement("p", "class", "slide-comment");
                    if (comment.getAuthor() != null) {
                        authorStringBuilder.append(comment.getAuthor());
                    }
                    if (comment.getAuthorInitials() != null) {
                        if (authorStringBuilder.length() > 0) {
                            authorStringBuilder.append(" ");
                        }
                        authorStringBuilder.append("(").append(comment.getAuthorInitials()).append(")");
                    }
                    if (comment.getText() != null && authorStringBuilder.length() > 0) {
                        authorStringBuilder.append(" - ");
                    }
                    if (authorStringBuilder.length() > 0) {
                        xhtml.startElement("b");
                        xhtml.characters(authorStringBuilder.toString());
                        xhtml.endElement("b");
                    }
                    xhtml.characters(comment.getText());
                    xhtml.endElement("p");
                }
            }
            this.handleGeneralTextContainingPart("http://schemas.openxmlformats.org/officeDocument/2006/relationships/diagramData", "diagram-data", slide.getPackagePart(), this.metadata, new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), new HashMap<String, String>()));
            this.handleGeneralTextContainingPart(XSLFRelation.CHART.getRelation(), "chart", slide.getPackagePart(), this.metadata, new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), new HashMap<String, String>()));
        }
    }

    private void extractContent(List<? extends XSLFShape> shapes, boolean skipPlaceholders, XHTMLContentHandler xhtml, String slideDesc) throws SAXException {
        for (XSLFShape xSLFShape : shapes) {
            Object relID;
            CTPicture ctPic;
            if (xSLFShape instanceof XSLFTextShape) {
                XSLFTextShape txt = (XSLFTextShape)xSLFShape;
                Placeholder ph = txt.getTextType();
                if (skipPlaceholders && ph != null) continue;
                boolean inHyperlink = false;
                for (XSLFTextParagraph p : txt.getTextParagraphs()) {
                    xhtml.startElement("p");
                    if (!this.config.isIncludeHeadersAndFooters() && p.isHeaderOrFooter()) continue;
                    for (XSLFTextRun run : p.getTextRuns()) {
                        XSLFHyperlink hyperlink = run.getHyperlink();
                        if (hyperlink != null && hyperlink.getAddress() != null && !hyperlink.getAddress().contains("#_ftn")) {
                            xhtml.startElement("a", "href", hyperlink.getAddress());
                            inHyperlink = true;
                        }
                        xhtml.characters(run.getRawText());
                        if (inHyperlink) {
                            xhtml.endElement("a");
                        }
                        inHyperlink = false;
                    }
                    xhtml.endElement("p");
                }
                continue;
            }
            if (xSLFShape instanceof XSLFGroupShape) {
                XSLFGroupShape group = (XSLFGroupShape)xSLFShape;
                this.extractContent(group.getShapes(), skipPlaceholders, xhtml, slideDesc);
                continue;
            }
            if (xSLFShape instanceof XSLFTable) {
                this.extractTable((XSLFTable)xSLFShape, xhtml);
                continue;
            }
            if (xSLFShape instanceof XSLFGraphicFrame) {
                XSLFGraphicFrame frame = (XSLFGraphicFrame)xSLFShape;
                XmlObject[] sp = frame.getXmlObject().selectPath("declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' .//*/p:oleObj");
                if (sp == null) continue;
                for (XmlObject emb : sp) {
                    XmlObject relIDAtt = emb.selectAttribute(new QName("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "id"));
                    if (relIDAtt == null) continue;
                    Object relID2 = relIDAtt.getDomNode().getNodeValue();
                    if (slideDesc != null) {
                        relID2 = slideDesc + (String)relID2;
                    }
                    AttributesImpl attributes = new AttributesImpl();
                    attributes.addAttribute("", "class", "class", "CDATA", "embedded");
                    attributes.addAttribute("", "id", "id", "CDATA", (String)relID2);
                    xhtml.startElement("div", attributes);
                    xhtml.endElement("div");
                }
                continue;
            }
            if (!(xSLFShape instanceof XSLFPictureShape) || skipPlaceholders || !(xSLFShape.getXmlObject() instanceof CTPicture) || (ctPic = (CTPicture)xSLFShape.getXmlObject()).getBlipFill() == null || ctPic.getBlipFill().getBlip() == null || (relID = ctPic.getBlipFill().getBlip().getEmbed()) == null) continue;
            if (slideDesc != null) {
                relID = slideDesc + (String)relID;
            }
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "class", "class", "CDATA", "embedded");
            attributes.addAttribute("", "id", "id", "CDATA", (String)relID);
            xhtml.startElement("div", attributes);
            xhtml.endElement("div");
        }
    }

    private void extractTable(XSLFTable tbl, XHTMLContentHandler xhtml) throws SAXException {
        xhtml.startElement("table");
        for (XSLFTableRow row : tbl) {
            xhtml.startElement("tr");
            for (XSLFTableCell c : row.getCells()) {
                xhtml.startElement("td");
                XSLFHyperlink hyperlink = null;
                try {
                    hyperlink = c.getHyperlink();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (hyperlink != null && hyperlink.getAddress() != null) {
                    xhtml.startElement("a", "href", hyperlink.getAddress());
                }
                xhtml.characters(c.getText());
                if (hyperlink != null && hyperlink.getAddress() != null) {
                    xhtml.endElement("a");
                }
                xhtml.endElement("td");
            }
            xhtml.endElement("tr");
        }
        xhtml.endElement("table");
    }

    @Override
    protected List<PackagePart> getMainDocumentParts() throws TikaException {
        ArrayList<PackagePart> parts = new ArrayList<PackagePart>();
        XSLFSlideShow document = null;
        try {
            document = new XSLFSlideShow(this.extractor.getPackage());
        }
        catch (Exception e) {
            throw new TikaException(e.getMessage());
        }
        CTSlideIdList ctSlideIdList = document.getSlideReferences();
        if (ctSlideIdList != null) {
            for (int i = 0; i < ctSlideIdList.sizeOfSldIdArray(); ++i) {
                PackagePart slidePart;
                CTSlideIdListEntry ctSlide = ctSlideIdList.getSldIdArray(i);
                try {
                    slidePart = document.getSlidePart(ctSlide);
                }
                catch (IOException | XmlException e) {
                    throw new TikaException("Broken OOXML file", e);
                }
                this.addSlideParts(slidePart, parts);
            }
        }
        parts.add(document.getPackagePart());
        for (String rel : new String[]{XSLFRelation.SLIDE_MASTER.getRelation(), HANDOUT_MASTER}) {
            try {
                PackageRelationshipCollection prc = document.getPackagePart().getRelationshipsByType(rel);
                for (int i = 0; i < prc.size(); ++i) {
                    PackagePart pp = document.getPackagePart().getRelatedPart(prc.getRelationship(i));
                    if (pp == null) continue;
                    parts.add(pp);
                }
            }
            catch (InvalidFormatException invalidFormatException) {
                // empty catch block
            }
        }
        return parts;
    }

    private void addSlideParts(PackagePart slidePart, List<PackagePart> parts) {
        for (String relation : new String[]{XSLFRelation.VML_DRAWING.getRelation(), XSLFRelation.SLIDE_LAYOUT.getRelation(), XSLFRelation.NOTES_MASTER.getRelation(), XSLFRelation.NOTES.getRelation(), XSLFRelation.CHART.getRelation(), XSLFRelation.DIAGRAM_DRAWING.getRelation()}) {
            try {
                for (PackageRelationship packageRelationship : slidePart.getRelationshipsByType(relation)) {
                    if (packageRelationship.getTargetMode() != TargetMode.INTERNAL) continue;
                    PackagePartName relName = PackagingURIHelper.createPartName(packageRelationship.getTargetURI());
                    parts.add(packageRelationship.getPackage().getPart(relName));
                }
            }
            catch (InvalidFormatException invalidFormatException) {
                // empty catch block
            }
        }
        parts.add(slidePart);
    }
}

