/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.crypt.CryptCodecProvider;
import com.healthmarketscience.jackcess.util.LinkResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.UnsupportedFormatException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.microsoft.JackcessExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class JackcessParser
implements Parser {
    public static final String SUMMARY_PROPERTY_PREFIX = "MDB_SUMMARY_PROP:";
    private static final LinkResolver IGNORE_LINK_RESOLVER = new IgnoreLinkResolver();
    private static final long serialVersionUID = -752276948656079347L;
    private static final MediaType MEDIA_TYPE = MediaType.application("x-msaccess");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MEDIA_TYPE);
    public static String MDB_PROPERTY_PREFIX = "MDB_PROP:";
    public static String USER_DEFINED_PROPERTY_PREFIX = "MDB_USER_PROP:";
    public static Property MDB_PW = Property.externalText("Password");
    private Locale locale = Locale.ROOT;

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        TikaInputStream tis = TikaInputStream.get(stream);
        Database db = null;
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        String password = null;
        PasswordProvider passwordProvider = context.get(PasswordProvider.class);
        if (passwordProvider != null) {
            password = passwordProvider.getPassword(metadata);
        }
        try {
            db = password == null ? new DatabaseBuilder(tis.getFile()).setCodecProvider(new CryptCodecProvider()).setReadOnly(true).open() : new DatabaseBuilder(tis.getFile()).setCodecProvider(new CryptCodecProvider(password)).setReadOnly(true).open();
            db.setLinkResolver(IGNORE_LINK_RESOLVER);
            JackcessExtractor ex = new JackcessExtractor(metadata, context, this.locale);
            ex.parse(db, xhtml);
        }
        catch (IOException e) {
            if (e.getMessage() != null && e.getMessage().contains("Unrecognized map type: 75")) {
                throw new UnsupportedFormatException("Jackcess doesn't process mdb versions before v97");
            }
            throw e;
        }
        catch (IllegalStateException e) {
            if (e.getMessage() != null && e.getMessage().contains("Incorrect password")) {
                throw new EncryptedDocumentException(e);
            }
            throw e;
        }
        finally {
            if (db != null) {
                try {
                    db.close();
                }
                catch (IOException iOException) {}
            }
        }
        xhtml.endDocument();
    }

    private static final class IgnoreLinkResolver
    implements LinkResolver {
        private IgnoreLinkResolver() {
        }

        @Override
        public Database resolveLinkedDatabase(Database database, String s) throws IOException {
            throw new AssertionError((Object)"DO NOT ALLOW RESOLVING OF LINKS!!!");
        }
    }
}

