/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.input;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.input.base.MRInputBase;
import org.apache.tez.mapreduce.lib.MRInputUtils;
import org.apache.tez.mapreduce.lib.MRReader;
import org.apache.tez.mapreduce.lib.MRReaderMapReduce;
import org.apache.tez.mapreduce.lib.MRReaderMapred;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.Reader;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MultiMRInput
extends MRInputBase {
    private static final Logger LOG = LoggerFactory.getLogger(MultiMRInput.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final AtomicInteger eventCount = new AtomicInteger(0);
    private List<MRReader> readers = new LinkedList<MRReader>();

    public MultiMRInput(InputContext inputContext, int numPhysicalInputs) {
        super(inputContext, numPhysicalInputs);
    }

    public static MultiMRInputConfigBuilder createConfigBuilder(Configuration conf, @Nullable Class<?> inputFormat) {
        MultiMRInputConfigBuilder configBuilder = new MultiMRInputConfigBuilder(conf, inputFormat);
        configBuilder.setInputClassName(MultiMRInput.class.getName()).groupSplits(false);
        return configBuilder;
    }

    @Override
    public List<Event> initialize() throws IOException {
        super.initialize();
        LOG.info(this.getContext().getSourceVertexName() + " using newmapreduce API=" + this.useNewApi + ", numPhysicalInputs=" + this.getNumPhysicalInputs());
        if (this.getNumPhysicalInputs() == 0) {
            this.getContext().inputIsReady();
        }
        return null;
    }

    public Collection<KeyValueReader> getKeyValueReaders() throws InterruptedException, IOException {
        this.lock.lock();
        try {
            while (this.eventCount.get() != this.getNumPhysicalInputs()) {
                this.condition.await();
            }
        }
        finally {
            this.lock.unlock();
        }
        return Collections.unmodifiableCollection(Lists.transform(this.readers, (Function)new Function<MRReader, KeyValueReader>(){

            public KeyValueReader apply(MRReader input) {
                return input;
            }
        }));
    }

    @Override
    public Reader getReader() throws Exception {
        throw new UnsupportedOperationException("getReader not supported. use getKeyValueReaders");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvents(List<Event> inputEvents) throws Exception {
        this.lock.lock();
        try {
            if (this.getNumPhysicalInputs() == 0) {
                throw new IllegalStateException("Unexpected event. MultiMRInput has been setup to receive 0 events");
            }
            Preconditions.checkState((this.eventCount.get() + inputEvents.size() <= this.getNumPhysicalInputs() ? 1 : 0) != 0, (Object)"Unexpected event. All physical sources already initialized");
            for (Event event : inputEvents) {
                MRReader reader = this.initFromEvent((InputDataInformationEvent)event);
                this.readers.add(reader);
                if (this.eventCount.incrementAndGet() != this.getNumPhysicalInputs()) continue;
                this.getContext().inputIsReady();
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private MRReader initFromEvent(InputDataInformationEvent event) throws IOException {
        Preconditions.checkState((event != null ? 1 : 0) != 0, (Object)"Event must be specified");
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getContext().getSourceVertexName() + " initializing Reader: " + this.eventCount.get());
        }
        MRRuntimeProtos.MRSplitProto splitProto = MRRuntimeProtos.MRSplitProto.parseFrom(ByteString.copyFrom((ByteBuffer)event.getUserPayload()));
        MRReader reader = null;
        JobConf localJobConf = new JobConf((Configuration)this.jobConf);
        long splitLength = -1L;
        if (this.useNewApi) {
            InputSplit split = MRInputUtils.getNewSplitDetailsFromEvent(splitProto, (Configuration)localJobConf);
            try {
                splitLength = split.getLength();
            }
            catch (InterruptedException e) {
                LOG.warn("Got interrupted while reading split length: ", (Throwable)e);
            }
            reader = new MRReaderMapReduce(localJobConf, split, this.getContext().getCounters(), this.inputRecordCounter, this.getContext().getApplicationId().getClusterTimestamp(), this.getContext().getTaskVertexIndex(), this.getContext().getApplicationId().getId(), this.getContext().getTaskIndex(), this.getContext().getTaskAttemptNumber(), this.getContext());
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getContext().getSourceVertexName() + " split Details -> SplitClass: " + split.getClass().getName() + ", NewSplit: " + split + ", length: " + splitLength);
            }
        } else {
            org.apache.hadoop.mapred.InputSplit split = MRInputUtils.getOldSplitDetailsFromEvent(splitProto, (Configuration)localJobConf);
            splitLength = split.getLength();
            reader = new MRReaderMapred(localJobConf, split, this.getContext().getCounters(), this.inputRecordCounter, this.getContext());
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getContext().getSourceVertexName() + " split Details -> SplitClass: " + split.getClass().getName() + ", OldSplit: " + split + ", length: " + splitLength);
            }
        }
        if (splitLength != -1L) {
            this.getContext().getCounters().findCounter((Enum)TaskCounter.INPUT_SPLIT_LENGTH_BYTES).increment(splitLength);
        }
        LOG.info(this.getContext().getSourceVertexName() + " initialized RecordReader from event");
        return reader;
    }

    public List<Event> close() throws Exception {
        for (MRReader reader : this.readers) {
            reader.close();
        }
        long inputRecords = this.getContext().getCounters().findCounter((Enum)TaskCounter.INPUT_RECORDS_PROCESSED).getValue();
        this.getContext().getStatisticsReporter().reportItemsProcessed(inputRecords);
        return null;
    }

    public void start() throws Exception {
        Preconditions.checkState((this.getNumPhysicalInputs() >= 0 ? 1 : 0) != 0, (Object)"Expecting zero or more physical inputs");
    }

    public static class MultiMRInputConfigBuilder
    extends MRInput.MRInputConfigBuilder {
        private MultiMRInputConfigBuilder(Configuration conf, Class<?> inputFormat) {
            super(conf, inputFormat);
        }
    }
}

